/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ynnx.dc.services.payment.salary;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ynnx.dc.services.Packer;
import kd.ebg.aqap.banks.ynnx.dc.services.Parser;
import kd.ebg.aqap.banks.ynnx.dc.services.payment.salary.QuerySalaryImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QuerySalaryImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = Packer.packRoot();
        Packer.packHead(root, this.getBizCode(), ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID());
        Element body = Packer.packBody(root);
        Element map = Packer.packMap(body);
        JDomUtils.addChild((Element)map, (String)"OptType", (String)"1");
        JDomUtils.addChild((Element)map, (String)"PayerAcNo", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        JDomUtils.addChild((Element)map, (String)"PayerAcName", (String)((PaymentInfo)paymentInfos.get(0)).getAccName());
        JDomUtils.addChild((Element)map, (String)"PayerCurrency", (String)((PaymentInfo)paymentInfos.get(0)).getCurrency());
        JDomUtils.addChild((Element)map, (String)"TotalCount", (String)(paymentInfos.size() + ""));
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            total = BigDecimalHelper.add((BigDecimal)total, (BigDecimal)((PaymentInfo)paymentInfos.get(i)).getAmount());
        }
        JDomUtils.addChild((Element)map, (String)"Amount", (String)total.toPlainString());
        JDomUtils.addChild((Element)map, (String)"Memo", (String)((PaymentInfo)paymentInfos.get(0)).getExplanation());
        JDomUtils.addChild((Element)map, (String)"SumMemo", (String)"");
        JDomUtils.addChild((Element)map, (String)"SMSFlag", (String)"");
        Element list = JDomUtils.addChild((Element)body, (String)"List");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(i);
            Element element = JDomUtils.addChild((Element)list, (String)"Map");
            JDomUtils.addChild((Element)element, (String)"PayeeAcNo", (String)paymentInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)element, (String)"Amount", (String)paymentInfo.getAmount().toPlainString());
            JDomUtils.addChild((Element)element, (String)"PayeeAcName", (String)paymentInfo.getIncomeAccName());
            JDomUtils.addChild((Element)element, (String)"Remark", (String)paymentInfo.getExplanation());
        }
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List<PaymentInfo> paymentInfos = Parser.parsePay(bankPayRequest, rspStr);
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EAgentData2Host";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u6536\u4ee3\u4ed8\u4ea4\u6613", (String)"SalaryPayImpl_0", (String)"ebg-aqap-banks-ynnx-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

