/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ynnx.dc.services.payment.samebank;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ynnx.dc.services.Packer;
import kd.ebg.aqap.banks.ynnx.dc.services.Parser;
import kd.ebg.aqap.banks.ynnx.dc.services.payment.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.INativeLinkPayable;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay,
INativeLinkPayable {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = Packer.packRoot();
        Packer.packHead(root, this.getBizCode(), paymentInfo.getBankDetailSeqID());
        Element body = Packer.packBody(root);
        Element map = Packer.packMap(body);
        JDomUtils.addChild((Element)map, (String)"PayerAcNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)map, (String)"PayerAcName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)map, (String)"PayeeAcNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)map, (String)"PayeeAcName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)map, (String)"Amount", (String)paymentInfo.getAmount().toPlainString());
        JDomUtils.addChild((Element)map, (String)"Currency", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)map, (String)"Remark", (String)(paymentInfo.getExplanation().length() > 30 ? paymentInfo.getExplanation().substring(0, 30) : paymentInfo.getExplanation()));
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List<PaymentInfo> paymentInfos = Parser.parsePay(bankPayRequest, rspStr);
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EBankInnerTransfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u884c\u5185\u8f6c\u5e10\u4ea4\u6613", (String)"PayImpl_1", (String)"ebg-aqap-banks-ynnx-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

