/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bod.cmp.service.payment.salary;

import java.io.InputStream;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bod.cmp.service.Packer;
import kd.ebg.aqap.banks.bod.cmp.service.Parser;
import kd.ebg.aqap.banks.bod.cmp.service.QueryPayProxyDownload;
import kd.ebg.aqap.banks.bod.cmp.utils.BOD_CMPUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.util.CommonPayStatusMatchUtil;
import kd.ebg.aqap.business.util.pojo.BankResPaymentInfo;
import kd.ebg.aqap.business.util.pojo.MatchPayStatusModel;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QuerySalaryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(QuerySalaryPayImpl.class);

    public int getBatchSize() {
        return 2000;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = Packer.createHead((String)"200201", (String)Sequence.genSequence());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)RequestContextUtils.getBankParameterValue((String)"CORP_NO"));
        String bankParameterValue = RequestContextUtils.getBankParameterValue((String)"testServerDate");
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)(StringUtils.isEmpty((String)bankParameterValue) ? ((PaymentInfo)paymentInfos.get(0)).getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")) : bankParameterValue));
        String serialNo = PaymentInfoSysFiled.get((PaymentInfo)((PaymentInfo)paymentInfos.get(0)), (String)"serial_no");
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)serialNo);
        String encoding = RequestContextUtils.getCharset();
        String xmlMessage = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return Packer.buildCommonMsg((String)xmlMessage);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        List paymentInfos = bankPayRequest.getPaymentInfos();
        BankResponse rsp = Parser.parserHead((Element)root);
        if (!"0".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u72b6\u6001\u7801\u4e3a\uff1a%1$s,\u94f6\u884c\u8fd4\u56de\u7684\u4fe1\u606f\u4e3a\uff1a%2$s", (String)"QuerySalaryPayImpl_1", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
            return new EBBankPayResponse(paymentInfos);
        }
        Element head = root.getChild("head");
        String file_flag = head.getChildTextTrim("file_flag");
        this.logger.info("\u8fd4\u56defile_flag:\u4e3a" + file_flag);
        Element body = root.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        if ("0".equals(record_num)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\uff0c\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u8bb0\u5f55\u6570\u4e3a0\uff0c\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u72b6\u6001\u3002", (String)"QuerySalaryPayImpl_2", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]));
            return new EBBankPayResponse(paymentInfos);
        }
        String data = "";
        if ("1".equals(file_flag)) {
            String file_name = body.getChildTextTrim("file_name");
            QueryPayProxyDownload proxyDownload = new QueryPayProxyDownload();
            data = proxyDownload.doBiz(file_name);
        } else if ("0".equals(file_flag)) {
            data = body.getChildTextTrim("serial_record");
        } else {
            this.logger.info("\u94f6\u884c\u8fd4\u56de\u7684\u6587\u4ef6\u6807\u8bc6\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u786e\u5b9a\u4ed8\u6b3e\u72b6\u6001");
            return new EBBankPayResponse(paymentInfos);
        }
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        String[] splits = StringUtils.split((String)data, (String)"|");
        ArrayList<BankResPaymentInfo> bankResPaymentInfos = new ArrayList<BankResPaymentInfo>(16);
        for (int i = 1; i <= recordNum; ++i) {
            String AMT;
            String accountName;
            String CARD_NO;
            String STAT;
            String ERR_MSG = splits[fieldNum * i + 10];
            if ("0".equals(file_flag) && "BOD_CMP".equalsIgnoreCase(bankPayRequest.getHeader().getBankVersionID())) {
                STAT = splits[fieldNum * i + 9];
                CARD_NO = splits[fieldNum * i + 1];
                accountName = splits[fieldNum * i + 3];
                AMT = splits[fieldNum * i + 5];
            } else {
                STAT = splits[fieldNum * i];
                CARD_NO = splits[fieldNum * i + 5];
                accountName = splits[fieldNum * i + 6];
                AMT = splits[fieldNum * i + 8];
            }
            BankResPaymentInfo bankResPaymentInfo = new BankResPaymentInfo(CARD_NO, accountName, AMT);
            bankResPaymentInfo.setBankStatus(STAT);
            bankResPaymentInfo.setBankMsg(ERR_MSG);
            if ("6".equals(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.FAIL);
            } else if ("9".equals(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUCCESS);
            } else if ("3".equals(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUBMITED);
            } else {
                bankResPaymentInfo.setPaymentState(PaymentState.UNKNOWN);
            }
            bankResPaymentInfos.add(bankResPaymentInfo);
        }
        MatchPayStatusModel matchPayStatusModel = new MatchPayStatusModel();
        matchPayStatusModel.setMatchRule("ACCOUNT_NAME_AMOUNT");
        matchPayStatusModel.setBankResPaymentInfoList(bankResPaymentInfos);
        List allPaymentInfo = CommonPayStatusMatchUtil.getAllPaymentInfoByBankBatchNo((String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID());
        return new EBBankPayResponse(CommonPayStatusMatchUtil.HandlePayStatus((MatchPayStatusModel)matchPayStatusModel, (List)allPaymentInfo));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200201";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u67e5\u8be2", (String)"QuerySalaryPayImpl_0", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]);
    }

    private boolean matchPayInfo(PaymentInfo paymentInfo, String accountName, String amount) {
        if (StringUtils.isEmpty((String)amount)) {
            this.logger.info("\u94f6\u884c\u8fd4\u56de\u91d1\u989d\u4e3a\u7a7a===\u65e0\u6cd5\u5339\u914d");
            return false;
        }
        if (StringUtils.isEmpty((String)accountName)) {
            this.logger.info("\u94f6\u884c\u8fd4\u56de\u8d26\u6237\u540d\u79f0\u4e3a\u7a7a===\u65e0\u6cd5\u5339\u914d");
            return false;
        }
        if (!accountName.equals(paymentInfo.getIncomeAccName())) {
            this.logger.info("\u94f6\u884c\u8fd4\u56de\u8d26\u6237\u540d\u79f0{}\u548c\u5f53\u524d\u8d26\u6237\u540d\u79f0{}\u4e0d\u5339\u914d", new Object[]{accountName, paymentInfo.getIncomeAccName()});
            return false;
        }
        BigDecimal bankAmount = new BigDecimal(amount);
        if (bankAmount.compareTo(paymentInfo.getAmount()) != 0) {
            this.logger.info("\u94f6\u884c\u8fd4\u56de\u7684\u91d1\u989d{}\u548c\u5f53\u524d\u91d1\u989d{}\u4e0d\u5339\u914d", new Object[]{bankAmount.toString(), paymentInfo.getAmount().toString()});
            return false;
        }
        return true;
    }

    public String recv(InputStream inputStream) {
        return BOD_CMPUtils.parseRecvMsg((String)super.recv(inputStream));
    }
}

