/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bod.cmp.service.payment.salary;

import java.io.InputStream;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bod.cmp.BankBussinessConfig;
import kd.ebg.aqap.banks.bod.cmp.service.Packer;
import kd.ebg.aqap.banks.bod.cmp.service.Parser;
import kd.ebg.aqap.banks.bod.cmp.service.ProxyUpload;
import kd.ebg.aqap.banks.bod.cmp.service.payment.salary.QuerySalaryPayImpl;
import kd.ebg.aqap.banks.bod.cmp.utils.BOD_CMPUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryPayImpl
extends AbstractPayImpl
implements IPay {
    private static final String FILE_HEDAER = "acno|acname|amt|postscript|";

    public int getBatchSize() {
        return 2000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QuerySalaryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = Packer.createHead((String)"300002", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId(), (boolean)true);
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)((PaymentInfo)paymentInfos.get(0)).getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)((PaymentInfo)paymentInfos.get(0)).getAccName());
        JDomUtils.addChild((Element)body, (String)"as_flag", (String)"0");
        String projectNo = BankBussinessConfig.getProjectNo(bankPayRequest.getAcnt().getAccNo());
        if (StringUtils.isEmpty((String)projectNo)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u9879\u76ee\u7f16\u53f7\u4fe1\u606f\u5fc5\u586b\uff0c\u8bf7\u5728\u201c\u67e5\u8be2\u4e0e\u652f\u4ed8>\u94f6\u4f01\u8d26\u6237>\u9644\u52a0\u5c5e\u6027\u201d\u5185\u914d\u7f6e\u201c\u9879\u76ee\u7f16\u7801\u201d\uff0c\u518d\u63d0\u4ea4\u4ed8\u6b3e\u5355\u636e\u3002", (String)"SalaryPayImpl_1", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"projno", (String)projectNo);
        JDomUtils.addChild((Element)body, (String)"amt", (String)String.valueOf(((PaymentInfo)paymentInfos.get(0)).getTotalAmount()));
        JDomUtils.addChild((Element)body, (String)"count", (String)String.valueOf(paymentInfos.size()));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)((PaymentInfo)paymentInfos.get(0)).getExplanation());
        JDomUtils.addChild((Element)body, (String)"postscript", (String)((PaymentInfo)paymentInfos.get(0)).getExplanation());
        JDomUtils.addChild((Element)body, (String)"tranfg", (String)"1");
        String fileName = "salary_pay_" + ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId() + ".txt";
        JDomUtils.addChild((Element)body, (String)"file_name", (String)fileName);
        StringBuilder fileTextBuffer = new StringBuilder();
        fileTextBuffer.append(FILE_HEDAER);
        fileTextBuffer.append("\r\n");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            ((PaymentInfo)paymentInfos.get(i)).setBankRefID(i + 1 + "");
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo());
            fileTextBuffer.append('|');
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getIncomeAccName()).append('|');
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getAmount()).append('|');
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getExplanation()).append('|');
            fileTextBuffer.append("\r\n");
        }
        String encoding = RequestContextUtils.getCharset();
        String xmlMessage = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        ProxyUpload proxyUpload = new ProxyUpload(fileTextBuffer.toString());
        if (!proxyUpload.doBiz(fileName)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u8bf7\u6c42\u5931\u8d25\u3002", (String)"SalaryPayImpl_2", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]));
        }
        return Packer.buildCommonMsg((String)xmlMessage);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        List paymentInfos = bankPayRequest.getPaymentInfos();
        BankResponse rsp = Parser.parserHead((Element)root);
        Element head = root.getChild("head");
        String serialNo = head.getChildText("serial_no");
        if (StringUtils.isEmpty((String)serialNo)) {
            serialNo = "";
        }
        PaymentInfoSysFiled.set((List)paymentInfos, (String)"serial_no", (String)serialNo);
        if ("0".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "300002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44", (String)"SalaryPayImpl_0", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        if ("pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType())) {
            return UseConvertor.isSalary((PaymentInfo)paymentInfo);
        }
        return false;
    }

    public String recv(InputStream inputStream) {
        return BOD_CMPUtils.parseRecvMsg((String)super.recv(inputStream));
    }
}

