/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bod.cmp.service.payment.single;

import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bod.cmp.service.BOD_CMPSeqState;
import kd.ebg.aqap.banks.bod.cmp.service.Packer;
import kd.ebg.aqap.banks.bod.cmp.service.Parser;
import kd.ebg.aqap.banks.bod.cmp.utils.BOD_CMPUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SingleQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public void configFactory(ConnectionFactory factory) {
        factory.addHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200205";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4f01\u4e1a\u4ea4\u6613\u6d41\u6c34\u72b6\u6001\u3002", (String)"SingleQueryPayImpl_0", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        return BOD_CMPUtils.parseRecvMsg((String)super.recv(inputStream));
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u7684\u67e5\u8be2\u4f01\u4e1a\u4ea4\u6613\u6d41\u6c34\u72b6\u6001\u63a5\u53e3\u4e0d\u652f\u6301\u6279\u91cf\u67e5\u8be2\u3002", (String)"SingleQueryPayImpl_1", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]));
        }
        Element root = Packer.createHead((String)"200205", (String)request.getHeader().getRequestSeqID());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)paymentInfos[0].getPackageId());
        JDomUtils.addChild((Element)body, (String)"req_no", (String)paymentInfos[0].getPackageId());
        String bankParameterValue = RequestContextUtils.getBankParameterValue((String)"testServerDate");
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)(StringUtils.isEmpty((String)bankParameterValue) ? paymentInfos[0].getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")) : bankParameterValue));
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)RequestContextUtils.getBankParameterValue((String)"CORP_NO"));
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return Packer.buildCommonMsg((String)xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        List paymentInfos = request.getPaymentInfos();
        BankResponse rsp = Parser.parserHead((Element)root);
        if (!"0".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u72b6\u6001\u7801\u4e3a\uff1a%1$s\uff0c\u94f6\u884c\u8fd4\u56de\u7684\u4fe1\u606f\u4e3a\uff1a%2$s\u3002", (String)"SingleQueryPayImpl_8", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = root.getChild("body");
        String reqNo = body.getChildTextTrim("req_no");
        String ret_code = body.getChildTextTrim("stat");
        String error_info = body.getChildTextTrim("error_info");
        String stateMsg = BOD_CMPSeqState.getByStateID((String)ret_code);
        String eMsg = String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7ed3\u679c[\u72b6\u6001\u7801:%1$s,\u72b6\u6001\u7801\u63cf\u8ff0:%2$s,\u9519\u8bef\u63cf\u8ff0:%3$s]", (String)"SingleQueryPayImpl_10", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]), ret_code, stateMsg, error_info);
        if ("6".equals(ret_code)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)PaymentState.FAIL.getCnName(), (String)ret_code, (String)eMsg);
        } else if ("9".equals(ret_code)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)PaymentState.SUCCESS.getCnName(), (String)ret_code, (String)PaymentState.SUCCESS.getCnName());
        } else if ("3".equals(ret_code)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)ret_code, (String)PaymentState.SUBMITED.getCnName());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)ret_code, (String)eMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

