/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.global.service.balance;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.global.service.Packer;
import kd.ebg.aqap.banks.boc.net.global.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.global.service.login.LoginAccessManager;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankBalanceRequest bankBalanceRequest) {
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            BankAcnt acnt = bankBalanceRequest.getAcnt();
            String accNo = acnt.getAccNo();
            Element root = Packer.getHeader((String)token, (String)"b2e0039");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0039-rq");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0039-rq");
            Element account = JDomUtils.addChild((Element)rq, (String)"account");
            JDomUtils.addChild((Element)account, (String)"ibknum", (String)acnt.getAreaCode());
            JDomUtils.addChild((Element)account, (String)"actacn", (String)accNo);
            Element datescope = JDomUtils.addChild((Element)rq, (String)"datescope");
            JDomUtils.addChild((Element)datescope, (String)"from", (String)bankBalanceRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)datescope, (String)"to", (String)bankBalanceRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            la.unavailableRelease();
        }
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0039-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        if (!"B001".equalsIgnoreCase(rspcod)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rspcod, (String)rspmsg));
        }
        ArrayList<BalanceInfo> hisBalanceList = new ArrayList<BalanceInfo>(16);
        List rsList = trn.getChildren("b2e0039-rs");
        for (Element rs : rsList) {
            BalanceInfo balanceInfo = new BalanceInfo();
            Element another_status = rs.getChild("status");
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            String another_rspmsg = another_status.getChildTextTrim("rspmsg");
            if (!"B001".equalsIgnoreCase(another_rspcod)) {
                balanceInfo.setError(ShowTipUtil.getResponseErrorTips((String)another_rspcod, (String)another_rspmsg));
                balanceInfo.setBankAcnt(bankBalanceRequest.getAcnt());
            } else {
                Element account = rs.getChild("account");
                String actacn = account.getChildTextTrim("actacn");
                this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), actacn);
                Element balance = rs.getChild("balance");
                String todbal = balance.getChildText("todbal");
                String curcde = balance.getChildText("curcde");
                String baldat = balance.getChildText("baldat");
                this.setCurrentBalance(balanceInfo, todbal);
                this.setBankCurrency(balanceInfo, bankBalanceRequest.getCurrency(), curcde);
                this.setBalanceDateTime(balanceInfo, baldat + "235959", DateTimeFormatter.ofPattern("yyyy/MM/ddHHmmss"));
            }
            hisBalanceList.add(balanceInfo);
        }
        return new EBBankBalanceResponse(hisBalanceList);
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "b2e0039";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5168\u7403\u8d26\u6237\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HisBalanceImpl_1", (String)"ebg-aqap-banks-boc-net-global", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public int queryDays() {
        return 180;
    }
}

