/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hdb.dcn.services.payment.otherbank;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hdb.dcn.services.payment.QueryPayImpl;
import kd.ebg.aqap.banks.hdb.dcn.services.utils.Packer;
import kd.ebg.aqap.banks.hdb.dcn.services.utils.Parser;
import kd.ebg.aqap.banks.hdb.dcn.services.utils.Signature;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public void configFactory(ConnectionFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append("/linkbank/");
        sb.append(this.getBizCode());
        sb.append(".do");
        factory.setUri(sb.toString());
        factory.setHttpHeader("signature", RequestContextUtils.getRunningParam((String)"sign"));
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        Element root = Packer.packCommHeader();
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        Element listElement = JDomUtils.addChild((Element)body, (String)"linkReqList");
        PaymentInfo info = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        JDomUtils.addChild((Element)listElement, (String)"payerAccNo", (String)info.getAccNo());
        JDomUtils.addChild((Element)listElement, (String)"payerAccName", (String)info.getAccName());
        JDomUtils.addChild((Element)listElement, (String)"payeeAccNo", (String)info.getIncomeAccNo());
        JDomUtils.addChild((Element)listElement, (String)"payeeAccName", (String)info.getIncomeAccName());
        JDomUtils.addChild((Element)listElement, (String)"payeeBank", (String)info.getIncomeBankName());
        JDomUtils.addChild((Element)listElement, (String)"payeeLinkBank", (String)info.getIncomeCnaps());
        JDomUtils.addChild((Element)listElement, (String)"amount", (String)BigDecimalHelper.plain2((BigDecimal)info.getAmount()));
        JDomUtils.addChild((Element)listElement, (String)"currency", (String)info.getCurrency());
        JDomUtils.addChild((Element)listElement, (String)"remark", (String)info.getExplanation());
        String data = JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
        String sign = Signature.getInstance().sign(data, this.getBizCode());
        RequestContextUtils.setRunningParam((String)"sign", (String)sign);
        return data;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        return Parser.parsePay(bankPayRequest, rspStr);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "LB00004";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94f6\u4f01\u76f4\u8054\u8de8\u884c\u8f6c\u8d26\u4ea4\u6613", (String)"PayImpl_0", (String)"ebg-aqap-banks-hdb-dcn", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

