/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zsb.opa.services.payment.oversea;

import com.alibaba.fastjson.JSON;
import com.czb.sap.sdk.ServiceBean;
import com.czb.sap.sdk.inf.UploadFileIn;
import com.czb.sap.sdk.inf.UploadFileOut;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zsb.opa.services.token.TokenService;
import kd.ebg.aqap.banks.zsb.opa.services.utils.SdkInit;
import kd.ebg.aqap.business.file.AbstractAttachmentImpl;
import kd.ebg.aqap.business.payment.bank.BankAttachmentRequest;
import kd.ebg.aqap.business.payment.bank.BankAttachmentResponse;
import kd.ebg.aqap.common.entity.biz.status.AttachmentState;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.file.PayAttachment;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class AttachmentUploadImpl
extends AbstractAttachmentImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(AttachmentUploadImpl.class);

    public String pack(PayAttachment payAttachment) {
        return null;
    }

    public void parse(PayAttachment payAttachment, String s) {
    }

    public BankAttachmentResponse doBiz(BankAttachmentRequest bankAttachmentRequest) {
        List attachments = bankAttachmentRequest.getPayAttachments();
        if (CollectionUtil.isEmpty((Collection)attachments)) {
            return new BankAttachmentResponse(attachments);
        }
        super.prepareAttachment(attachments);
        PayAttachment payAttachment = (PayAttachment)attachments.get(0);
        String overseaAttachmentPath = super.getOverseaAttachmentPath(payAttachment.getBankVersionID());
        String fileName = payAttachment.getFileName();
        Path path = Paths.get(overseaAttachmentPath + File.separator + fileName, new String[0]);
        try {
            UploadFileIn uploadFileIn = new UploadFileIn();
            uploadFileIn.setFilename(fileName);
            uploadFileIn.setFilegroup(payAttachment.getBankBatchSeqID());
            uploadFileIn.setTraceno(Sequence.genSequence());
            uploadFileIn.setFile(Files.readAllBytes(path));
            uploadFileIn.setToken(TokenService.getInstance().getToken());
            logger.info("\u6587\u4ef6\u4e0a\u4f20\u8bf7\u6c42\u62a5\u6587:{}", (Object)JSON.toJSONString((Object)uploadFileIn));
            UploadFileOut uploadFileOut = ServiceBean.getService((String)SdkInit.getTenantKey()).uploadFile(uploadFileIn);
            logger.info("\u6587\u4ef6\u4e0a\u4f20\u54cd\u5e94\u62a5\u6587:{}", (Object)JSON.toJSONString((Object)uploadFileOut));
            String statusCode = uploadFileOut.getResultcode();
            String statusDesc = uploadFileOut.getResultdesc();
            if ("000000".equalsIgnoreCase(statusCode)) {
                String fileID = uploadFileOut.getFileid();
                logger.info("\u4e0a\u4f20\u9644\u4ef6\u6210\u529f\uff0cfileid\uff1a{}\u3002", (Object)fileID);
                payAttachment.setFileID(fileID);
                this.setUploadStatus(attachments, AttachmentState.SUCCESS, "", statusDesc);
            } else {
                logger.info("\u4e0a\u4f20\u9644\u4ef6\u5931\u8d25\uff0c\u72b6\u6001\u7801{}\u3002", (Object)statusDesc);
                this.setUploadStatus(payAttachment, AttachmentState.FAIL, "", statusDesc);
            }
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage());
            this.setUploadStatus(payAttachment, AttachmentState.FAIL, "", ResManager.loadKDString((String)"\u9644\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"AttachmentUploadImpl_0", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            String message = e.getMessage();
            if (StringUtils.isNotEmpty((String)message) && message.length() > 255) {
                message = message.substring(0, 255);
            }
            this.setUploadStatus(payAttachment, AttachmentState.UNKNOWN, "", message);
        }
        return new BankAttachmentResponse(attachments);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "uploadFile";
    }

    public String getBizDesc() {
        return "";
    }
}

