/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zsb.opa.services.payment.oversea;

import com.alibaba.fastjson.JSONObject;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zsb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.zsb.opa.services.payment.oversea.AttachmentUploadImpl;
import kd.ebg.aqap.banks.zsb.opa.services.payment.oversea.ExcrossQueryCommForeignCurPayStatus;
import kd.ebg.aqap.banks.zsb.opa.services.token.TokenService;
import kd.ebg.aqap.banks.zsb.opa.services.utils.SdkInit;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankAttachmentRequest;
import kd.ebg.aqap.business.payment.bank.BankAttachmentResponse;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.AttachmentState;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.framework.service.file.PayAttachmentService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.file.PayAttachment;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;

public class ExcrossCommonForeignCurPay
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ExcrossCommonForeignCurPay.class);

    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return ExcrossQueryCommForeignCurPayStatus.class;
    }

    public EBBankPayResponse pay(BankPayRequest request) {
        try {
            String payeeBankFlag;
            SdkInit.init();
            List paymentInfos = request.getPaymentInfos();
            BankAcnt payerAccount = request.getAcnt();
            PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
            HashMap<String, Object> body = new HashMap<String, Object>(32);
            CountryISOCode payeeCode = this.getOrThrow(info.getIncomeCountry(), ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u56fd\u5bb6\u5730\u533a(incomeCountry)\u5fc5\u586b\u3002", (String)"ExcrossCommonForeignCurPay_0", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
            boolean isForeignPayee = !"CN".equalsIgnoreCase(payeeCode.geteChart2());
            logger.info("\u4ed8\u6b3e\u65b9\u8d26\u53f7\u6240\u5728\u56fd\u5bb6\u5730\u533a {}", (Object)info.getAccCountry());
            CountryISOCode payerCode = this.getOrThrow(info.getAccCountry(), ResManager.loadKDString((String)"\u4ed8\u6b3e\u65b9\u8d26\u6237\u56fd\u5bb6\u5730\u533a\u5fc5\u586b\u3002", (String)"ExcrossCommonForeignCurPay_1", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
            boolean isForeignPayer = !"CN".equalsIgnoreCase(payerCode.geteChart2());
            boolean isOversea = isForeignPayee || isForeignPayer;
            body.put("tradeId", info.getBankDetailSeqId());
            body.put("customerId", BankBusinessConfig.getCustomerIDForWBPay(info.getAccNo()));
            boolean isoCurrency = CurrencyUtils.isISOCurrency((String)info.getPayCurrency());
            if (isoCurrency) {
                body.put("txCcy", CurrencyUtils.convert2Bank((String)info.getPayCurrency()));
            } else {
                body.put("txCcy", info.getPayCurrency());
            }
            body.put("txAmt", info.getAmount().toPlainString());
            body.put("payerOrgCode", "");
            body.put("payerAccNo", info.getAccNo());
            if (info.getUseCN().equalsIgnoreCase("FTN")) {
                String currency = payerAccount.getCurrency();
                currency = CurrencyUtils.convert2Bank((String)currency);
                body.put("payerAccCcy", currency);
            }
            body.put("subPayerAccNo", "");
            String zhAccName = info.getAccName();
            String enAccName = this.ensureNonNull(payerAccount.getEnAccName(), zhAccName);
            if (info.is2SameBank() || !isOversea) {
                body.put("payerName", this.limitLength(zhAccName, 60));
                body.put("payerAddress", "");
                body.put("payerCountry", "");
            } else {
                int totalLength = 160 - payerCode.getSimpleEn().length();
                if (enAccName.length() + info.getPayerAddress().length() > totalLength) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8d26\u6237\u6237\u540d\u4e0e\u5730\u5740\uff08payerAddress\uff09\u5408\u8ba1\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u5b57\u7b26\u3002", (String)"ExcrossCommonForeignCurPay_2", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), totalLength));
                }
                if (this.containsChinese(enAccName + info.getPayerAddress())) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8d26\u6237\u6237\u540d\u4e0e\u5730\u5740(payerAddress)\u4e0d\u5141\u8bb8\u4e2d\u6587\u3002", (String)"ExcrossCommonForeignCurPay_3", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
                }
                String appendStr = enAccName + info.getPayerAddress();
                if (appendStr.contains("&") || appendStr.contains("/") || appendStr.contains("-")) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8d26\u6237\u6237\u540d\u4e0e\u5730\u5740\uff08payerAddress\uff09\u4e0d\u5f97\u51fa\u73b0\u201c&\u3001/\u3001-\u201d\u7b49\u7279\u6b8a\u5b57\u7b26\u3002", (String)"ExcrossCommonForeignCurPay_4", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
                }
                body.put("payerName", enAccName);
                body.put("payerAddress", info.getPayerAddress());
                body.put("payerCountry", payerCode.getSimpleEn().toUpperCase(Locale.ENGLISH));
            }
            body.put("tradeDate", info.getBookingTime().format(DateTimeFormatter.BASIC_ISO_DATE));
            body.put("shareAccNo", "");
            if (info.is2SameBank()) {
                payeeBankFlag = "2";
                if (isForeignPayee) {
                    body.put("payeeBankNameId", "0");
                } else {
                    body.put("payeeBankNameId", "2");
                }
            } else if (isForeignPayee) {
                payeeBankFlag = "0";
                body.put("payeeBankNameId", "0");
            } else {
                payeeBankFlag = "1";
                body.put("payeeBankNameId", "1");
            }
            body.put("payeeAccNo", info.getIncomeAccNo());
            String incomeAccName = info.getIncomeAccName();
            String incomeAddress = info.getIncomeAddress();
            body.put("payeeBankSwiftBic", info.getIncomeSwiftCode());
            if ("0".equalsIgnoreCase(payeeBankFlag)) {
                int totalLength = 131;
                if (incomeAccName.length() + incomeAddress.length() > totalLength) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u6237\u540d\u4e0e\u6536\u6b3e\u4eba\u5730\u5740\u5408\u8ba1\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u5b57\u7b26\u3002", (String)"ExcrossCommonForeignCurPay_5", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), totalLength));
                }
                body.put("payeeEnglishName", incomeAccName);
                body.put("payeeEnglishAddress", incomeAddress);
                body.put("recvCountry", payeeCode.getSimpleEn());
                body.put("payeeBankNameAndAddr", "");
                body.put("payeeLocalBankno", info.getIncomeBankLocalClearingCode());
                body.put("payeeBankAccNo", "");
                body.put("midTransBank", "");
                if (this.containsChinese(info.getExplanation())) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u9644\u8a00\u4e0d\u5141\u8bb8\u5305\u542b\u4e2d\u6587\u4e14\u7b2c36\uff0c71\uff0c106\u4f4d\u5b57\u7b26\u4e0d\u53ef\u4ee5\u4e3a\u5168\u89d2\u5b57\u7b26\u3002", (String)"ExcrossCommonForeignCurPay_6", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
                }
                body.put("postscript", this.limitLength(info.getExplanation(), 140));
            } else if ("1".equalsIgnoreCase(payeeBankFlag)) {
                body.put("oppUser", this.limitLength(incomeAccName, 60));
                body.put("payeeAddress", this.limitLength(incomeAddress, 63));
                body.put("payeeBankName", "");
                body.put("postscript", this.limitLength(info.getExplanation(), 132));
                body.put("businessType", info.getBusinessTypeCode());
                body.put("payerAccProperty", "");
            } else {
                body.put("oppUser", this.limitLength(incomeAccName, 60));
                body.put("postscript", this.limitLength(info.getExplanation(), 60));
            }
            if (info.is2SameBank()) {
                body.put("feeType", "");
                body.put("feeAccNo", "");
            } else {
                String feeType;
                body.put("feeAccNo", info.getPayerFeeAccNo());
                if ("01".equalsIgnoreCase(info.getPayerFeeType())) {
                    feeType = "OUR";
                } else if ("02".equalsIgnoreCase(info.getPayerFeeType())) {
                    feeType = "BEN";
                    body.put("feeAccNo", "");
                } else {
                    feeType = "SHA";
                }
                body.put("feeType", feeType);
            }
            if (StringUtils.isEmpty((String)info.getDeclareFlag())) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7533\u62a5\u6807\u8bc6(declareFlag)\u5fc5\u586b\u3002", (String)"ExcrossCommonForeignCurPay_7", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
            }
            body.put("repInfoCate", info.getDeclareFlag());
            body.put("isRef", info.isBondGoodsFlag() ? "Y" : "N");
            body.put("tx1Code", info.getTxCode());
            body.put("tx1Amt", info.getAmount().toPlainString());
            body.put("tx1Rem", info.getTxPostscript());
            body.put("tx2Code", "");
            body.put("tx2Amt", "");
            body.put("tx2Rem", "");
            String contractNo = this.ensureNonNull(info.getContractNo(), "N/A");
            String invoiceNo = this.ensureNonNull(info.getInvoiceNo(), "N/A");
            body.put("contrNo", contractNo);
            body.put("invoiNo", invoiceNo);
            body.put("regNo", "");
            body.put("crtUser", info.getApplyName());
            body.put("inptelc", info.getApplyPhone());
            String pay_type = "O";
            if ("1".equalsIgnoreCase(info.getPayProperty())) {
                pay_type = "P";
            } else if ("0".equalsIgnoreCase(info.getPayProperty())) {
                pay_type = "A";
            } else if ("2".equalsIgnoreCase(info.getPayProperty())) {
                pay_type = "R";
            }
            body.put("amtType", pay_type);
            body.put("country", payerCode.geteChart3());
            String payAttribute = "6";
            if ("D".equalsIgnoreCase(info.getPayAttribute())) {
                payAttribute = "3";
            } else if ("E".equalsIgnoreCase(info.getPayAttribute())) {
                payAttribute = "2";
            } else if ("M".equalsIgnoreCase(info.getPayAttribute())) {
                payAttribute = "5";
            } else if ("X".equalsIgnoreCase(info.getPayAttribute())) {
                payAttribute = "1";
            }
            body.put("payType", payAttribute);
            String fileId = "";
            List payAttachments = PayAttachmentService.getInstance().findByBankBatchSeqId(info.getBankBatchSeqID());
            if (payAttachments.size() > 1) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4e0a\u4f201\u4e2a\u5f71\u50cf\u9644\u4ef6\u3002", (String)"ExcrossCommonForeignCurPay_8", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
            }
            if (!payAttachments.isEmpty()) {
                EBContext context = EBContext.getContext();
                BankAttachmentResponse attachmentResponse = new AttachmentUploadImpl().doBiz(this.newAttachmentRequest(payAttachments, info));
                EBContext.setContext((EBContext)context);
                PayAttachment payAttachment = (PayAttachment)attachmentResponse.getPayAttachments().get(0);
                if (payAttachment.getStatus().intValue() == AttachmentState.SUCCESS.getId()) {
                    fileId = ((PayAttachment)attachmentResponse.getPayAttachments().get(0)).getFileID();
                } else {
                    if (payAttachment.getStatus().intValue() == AttachmentState.FAIL.getId()) {
                        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5f71\u50cf\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c%s\u3002", (String)"ExcrossCommonForeignCurPay_9", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), payAttachment.getBankMsg()));
                    }
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f71\u50cf\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25\u3002", (String)"ExcrossCommonForeignCurPay_10", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
                }
            }
            body.put("fileId", fileId);
            body.put("rmk1", "");
            body.put("rmk2", "");
            body.put("rmk3", "");
            String token = TokenService.getInstance().getToken();
            try {
                String rsp = SdkInit.send("excross_commonForeignCurPay", info.getBankDetailSeqId(), token, body);
                return this.parse(request, rsp);
            }
            catch (Throwable t) {
                EBContext.getContext().setThrowableAfterSend(t);
                return null;
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.payFailException((String)ResManager.loadKDString((String)"\u6253\u5305\u94f6\u884c\u4ed8\u6b3e\u8bf7\u6c42\u62a5\u6587\u51fa\u73b0\u5f02\u5e38\u3002", (String)"PayImpl_5", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        JSONObject root = JSONObject.parseObject((String)s);
        String statusCode = root.getString("resultcode");
        String statusDesc = root.getString("resultdesc");
        if (!"000000".equals(statusCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)statusCode, (String)statusDesc);
            return new EBBankPayResponse(paymentInfos);
        }
        JSONObject body = root.getJSONObject("body");
        String status = body.getString("payStatus");
        String desc = body.getString("desc");
        if ("1".equals(status) || "2".equals(status)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)status, (String)desc);
        } else if ("3".equals(status)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)status, (String)desc);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)status, (String)desc);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "excross_commonForeignCurPay";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String ensureNonNull(String s, String defaultStr) {
        if (StringUtils.isEmpty((String)s)) {
            return defaultStr;
        }
        return s;
    }

    public boolean containsChinese(String str) {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5\uff01\uff0c\u3002\uff08\uff09\u300a\u300b\u201c\u201d\uff1f\uff1a\uff1b\u3010\u3011]");
        Matcher m = p.matcher(str);
        return m.find();
    }

    public String limitLength(String str, int limit) {
        if (StringUtils.isEmpty((String)str)) {
            return "";
        }
        return str.substring(0, Math.min(limit, str.length()));
    }

    public CountryISOCode getOrThrow(String country, String message) {
        CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfoByName(country);
        if (null == code) {
            code = ISOCountryUtils.getInstance().getCountryInfo(country);
        }
        if (code == null) {
            throw EBExceiptionUtil.serviceException((String)message);
        }
        return code;
    }

    public BankAttachmentRequest newAttachmentRequest(List<PayAttachment> payAttachments, PaymentInfo paymentInfo) {
        PayAttachment payAttachment = payAttachments.get(0);
        EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(payAttachment.getCustomID()).logRequestSeqID(paymentInfo.getBankBatchSeqID()).bizName("attachmentUpload").subBizName("attachmentUpload").bankVersionID(payAttachment.getBankVersionID()).bankLoginID(payAttachment.getBankLoginID()).logBizSeqID(paymentInfo.getBankBatchSeqID()).bizSeqID(Sequence.genSequence()).requestSeqID(Sequence.genSequence()).loggerBatchNo(paymentInfo.getBankBatchSeqID()).loggerDetailNo(Sequence.genSequence()).loggerBankNo(Sequence.genSequence()).build();
        BankAcnt bankAcnt = new BankAcnt();
        context.setBankAcnt(bankAcnt);
        EBContext.setContext((EBContext)context);
        EBContext.initParameter();
        BankAttachmentRequest bankAttachmentRequest = new BankAttachmentRequest();
        bankAttachmentRequest.setPayAttachments(payAttachments);
        return bankAttachmentRequest;
    }
}

