/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zsb.opa.services.payment.oversea;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import kd.ebg.aqap.banks.zsb.opa.ZsbOpaMetaDataImpl;
import kd.ebg.aqap.banks.zsb.opa.services.utils.SdkInit;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;

public class ExcrossQueryCommForeignCurPayStatus
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 0;
    }

    public EBBankPayResponse queryPay(BankPayRequest request) {
        SdkInit.init();
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        HashMap<String, Object> body = new HashMap<String, Object>(5);
        body.put("tradeId", info.getBankDetailSeqId());
        body.put("customerId", RequestContextUtils.getBankParameterValue((String)ZsbOpaMetaDataImpl.openid));
        body.put("payerAccNo", info.getAccNo());
        boolean isoCurrency = CurrencyUtils.isISOCurrency((String)info.getPayCurrency());
        if (isoCurrency) {
            body.put("txCcy", CurrencyUtils.convert2Bank((String)info.getPayCurrency()));
        } else {
            body.put("txCcy", info.getPayCurrency());
        }
        body.put("txAmt", "");
        body.put("rmk1", "");
        body.put("rmk2", "");
        body.put("rmk3", "");
        String rspStr = SdkInit.send("excross_queryCommForeignCurPayStatus", Sequence.genSequence(), body);
        return this.parse(request, rspStr);
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        JSONObject root = JSON.parseObject((String)rspStr);
        String statusCode = root.getString("resultcode");
        String statusDesc = root.getString("resultdesc");
        if (!"000000".equals(statusCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)statusCode, (String)statusDesc);
        } else {
            JSONObject body = root.getJSONObject("body");
            String status = body.getString("payStatus");
            String desc = body.getString("desc");
            if ("1".equals(status)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)status, (String)desc);
            } else if ("2".equals(status)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)status, (String)desc);
            } else if ("3".equals(status)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)status, (String)desc);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)status, (String)desc);
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "excross_queryCommForeignCurPayStatus";
    }

    public String getBizDesc() {
        return "";
    }
}

