/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bea.dc.utils;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.BalanceUtils;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BeaParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BeaParser.class);

    public static EBBankBalanceResponse parseHisBalance(BankBalanceRequest request, String responseStr) {
        responseStr = responseStr.replace("<RETURN_MESSAGE>", "").replace("</RETURN_MESSAGE>", "");
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element opRep = JDomUtils.getChildElement((Element)root, (String)"opRep");
        String retCode = JDomUtils.getChildText((Element)opRep, (String)"retCode");
        String errMsg = JDomUtils.getChildText((Element)opRep, (String)"errMsg");
        if (!"000000".equals(retCode)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)retCode, (String)errMsg));
        }
        Element opResultSet = JDomUtils.getChildElement((Element)opRep, (String)"opResultSet");
        List opResultList = opResultSet.getChildren("opResult");
        ArrayList<BalanceInfo> hisBalanceList = new ArrayList<BalanceInfo>(opResultList.size());
        for (Object opResultObj : opResultList) {
            BalanceInfo balanceInfo = new BalanceInfo();
            Element opResult = (Element)opResultObj;
            balanceInfo.setBankAcnt(request.getAcnt());
            String tranDate = JDomUtils.getChildTextTrim((Element)opResult, (String)"TRAN_DATE");
            try {
                LocalDateTime transDate = LocalDateTime.parse(tranDate + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                balanceInfo.setBalanceDateTime(transDate);
            }
            catch (Exception e) {
                balanceInfo.setError(BalanceUtils.wrongDateFormatter());
            }
            String actual_bal_amt = JDomUtils.getChildTextTrim((Element)opResult, (String)"ACTUAL_BAL_AMT");
            if (StringUtils.isNotEmpty((String)actual_bal_amt)) {
                balanceInfo.setCurrentBalance(new BigDecimal(actual_bal_amt).divide(new BigDecimal("100"), 2, 0));
            } else {
                balanceInfo.setError(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\u3002", (String)"BalanceUtils_0", (String)"ebg-aqap-banks-bea-dc", (Object[])new Object[0]));
            }
            balanceInfo.setBankCurrency(request.getBankCurrency());
            hisBalanceList.add(balanceInfo);
        }
        EBBankBalanceResponse ebBankBalanceResponse = new EBBankBalanceResponse(hisBalanceList);
        return ebBankBalanceResponse;
    }

    public static List<DetailInfo> parseDetail(BankDetailRequest request, String rspStr) {
        rspStr = rspStr.replace("<RETURN_MESSAGE>", "").replace("</RETURN_MESSAGE>", "");
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element opRep = JDomUtils.getChildElement((Element)root, (String)"opRep");
        String retCode = JDomUtils.getChildText((Element)opRep, (String)"retCode");
        String errMsg = JDomUtils.getChildText((Element)opRep, (String)"errMsg");
        if (!"000000".equalsIgnoreCase(retCode)) {
            Element opResult = JDomUtils.getChildElement((Element)opRep, (String)"opResult");
            String total_num = JDomUtils.getChildText((Element)opResult, (String)"TOTAL_NUM");
            if ("NDS300726_0105accBus".equalsIgnoreCase(retCode) || "0".equalsIgnoreCase(total_num)) {
                return Lists.newArrayList();
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e1c\u4e9a\u94f6\u884c\u67e5\u8be2\u660e\u7ec6\u51fa\u73b0\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s\uff0c\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"BeaParser_10", (String)"ebg-aqap-banks-bea-dc", (Object[])new Object[0]), retCode, errMsg));
        }
        Element opResultSet = JDomUtils.getChildElement((Element)opRep, (String)"opResultSet");
        List opResult = opResultSet.getChildren("opResult");
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(opResult.size());
        BankAcnt acnt = request.getAcnt();
        String currency = request.getBankCurrency();
        for (Object resultObj : opResult) {
            LocalDateTime tranDateTime;
            Element result = (Element)resultObj;
            String tran_date = result.getChildText("TRAN_DATE_1");
            String cr_dr_maint_ind = result.getChildText("CR_DR_MAINT_IND");
            String tran_amt = result.getChildText("TRAN_AMT");
            String ccy = result.getChildText("CCY");
            String reference = result.getChildText("REFERENCE");
            String branch = result.getChildText("BRANCH");
            String reference_branch = result.getChildText("REFERENCE_BRANCH");
            String tfr_acct_no = result.getChildText("TFR_ACCT_NO");
            String tfr_acct_name = result.getChildText("TFR_ACCT_NAME");
            String actual_bal_amt = result.getChildText("ACTUAL_BAL_AMT");
            String tran_desc = result.getChildText("TRAN_DESC");
            String mak1 = result.getChildText("MAK1");
            String mak2 = result.getChildText("MAK2");
            String mak3 = result.getChildText("MAK3");
            DetailInfo info = new DetailInfo();
            info.setAccNo(acnt.getAccNo());
            info.setAccName(acnt.getAccName());
            info.setBankName(acnt.getBankName());
            if (!currency.equals(ccy)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5e01\u79cd\u548c\u60a8\u7684\u67e5\u8be2\u6761\u4ef6\u4e0d\u7b26\uff0c\u67e5\u8be2\u6761\u4ef6\u5e01\u79cd\uff1a%1$s\uff0c\u94f6\u884c\u8fd4\u56de\u5e01\u79cd\uff1a%2$s\u3002", (String)"BeaParser_11", (String)"ebg-aqap-banks-bea-dc", (Object[])new Object[0]), currency, ccy));
            }
            info.setCurrency(currency);
            BigDecimal amout = BeaParser.FtoY(tran_amt.trim());
            if ("C".equals(cr_dr_maint_ind)) {
                info.setCreditAmount(amout);
                info.setDebitAmount(new BigDecimal("0.00"));
            } else {
                info.setDebitAmount(amout);
                info.setCreditAmount(new BigDecimal("0.00"));
            }
            if (!StringUtils.isEmpty((String)actual_bal_amt)) {
                BigDecimal balance = BeaParser.FtoY(actual_bal_amt.trim());
                info.setBalance(balance);
            }
            info.setOppAccNo(tfr_acct_no);
            info.setOppAccName(tfr_acct_name);
            info.setOppBankName(reference_branch);
            String time = "";
            time = StringUtils.isEmpty((String)mak2) ? "000000" : mak2;
            try {
                tranDateTime = LocalDateTime.parse(tran_date + time, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            }
            catch (Exception e) {
                tranDateTime = LocalDateTime.parse(tran_date + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            }
            info.setTransDate(LocalDate.parse(tran_date, DateTimeFormatter.ofPattern("yyyyMMdd")));
            info.setTransTime(tranDateTime);
            info.setExplanation(tran_desc);
            if (!StringUtils.isEmpty((String)mak3) && mak3.contains("KD")) {
                String kdRetFlag = mak3.substring(0, mak3.indexOf("KD"));
                DetailSysFiled.set((DetailInfo)info, (String)"KDRetFlag", (String)kdRetFlag);
                info.setPayBankDetailSeqID(kdRetFlag);
            }
            String json = MatchRule.getInstance().getDetailJsonWithStructuredData(result);
            info.setJsonMap(json);
            detailInfos.add(info);
        }
        return detailInfos;
    }

    private static BigDecimal FtoY(String ba) {
        if (StringUtils.isEmpty((String)ba)) {
            return new BigDecimal("0.00");
        }
        return new BigDecimal(ba).divide(new BigDecimal("100"), 2, 0);
    }

    public static EBBankPayResponse parsePay(BankPayRequest request, String responseStr) {
        responseStr = responseStr.replace("<RETURN_MESSAGE>", "").replace("</RETURN_MESSAGE>", "");
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element opRep = JDomUtils.getChildElement((Element)root, (String)"opRep");
        String retCode = JDomUtils.getChildText((Element)opRep, (String)"retCode");
        String errMsg = JDomUtils.getChildText((Element)opRep, (String)"errMsg");
        if ("000000".equals(retCode)) {
            Element opResult = JDomUtils.getChildElement((Element)opRep, (String)"opResult");
            String tran_flag = JDomUtils.getChildText((Element)opResult, (String)"TRAN_FLAG");
            String tran_msg = JDomUtils.getChildText((Element)opResult, (String)"TRAN_MSG");
            if ("20".equals(tran_flag) || "95".equals(tran_flag) || "96".equals(tran_flag)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BeaParser_5", (String)"ebg-aqap-banks-bea-dc", (Object[])new Object[0]), (String)tran_flag, (String)tran_msg);
            } else if ("90".equals(tran_flag)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"BeaParser_6", (String)"ebg-aqap-banks-bea-dc", (Object[])new Object[0]), (String)tran_flag, (String)tran_msg);
            } else if ("91".equals(tran_flag)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"BeaParser_7", (String)"ebg-aqap-banks-bea-dc", (Object[])new Object[0]), (String)tran_flag, (String)tran_msg);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"BeaParser_8", (String)"ebg-aqap-banks-bea-dc", (Object[])new Object[0]), (String)tran_flag, (String)tran_msg);
            }
        } else if ("API00095".equalsIgnoreCase(retCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BeaParser_5", (String)"ebg-aqap-banks-bea-dc", (Object[])new Object[0]), (String)retCode, (String)errMsg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"BeaParser_7", (String)"ebg-aqap-banks-bea-dc", (Object[])new Object[0]), (String)retCode, (String)errMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public static EBBankPayResponse parseQueryPay(BankPayRequest request, String responseStr) {
        responseStr = responseStr.replace("<RETURN_MESSAGE>", "").replace("</RETURN_MESSAGE>", "");
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element opRep = JDomUtils.getChildElement((Element)root, (String)"opRep");
        String retCode = JDomUtils.getChildText((Element)opRep, (String)"retCode");
        String errMsg = JDomUtils.getChildText((Element)opRep, (String)"errMsg");
        if (!"000000".equals(retCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"BeaParser_8", (String)"ebg-aqap-banks-bea-dc", (Object[])new Object[0]), (String)retCode, (String)errMsg);
        } else {
            Element opResult = JDomUtils.getChildElement((Element)opRep, (String)"opResult");
            String tran_falg = JDomUtils.getChildText((Element)opResult, (String)"TRAN_FALG");
            String ret_msg_1 = JDomUtils.getChildText((Element)opResult, (String)"RET_MSG_1");
            if (PropertiesConstants.getValue((String)"SUBMITED").equals(tran_falg)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BeaParser_5", (String)"ebg-aqap-banks-bea-dc", (Object[])new Object[0]), (String)tran_falg, (String)ret_msg_1);
            } else if (PropertiesConstants.getValue((String)"DEAL_SUCCESS").equals(tran_falg)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"BeaParser_6", (String)"ebg-aqap-banks-bea-dc", (Object[])new Object[0]), (String)tran_falg, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"BeaParser_6", (String)"ebg-aqap-banks-bea-dc", (Object[])new Object[0]));
            } else if (PropertiesConstants.getValue((String)"DEAL_FAIL").equals(tran_falg)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"BeaParser_7", (String)"ebg-aqap-banks-bea-dc", (Object[])new Object[0]), (String)tran_falg, (String)ret_msg_1);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"BeaParser_8", (String)"ebg-aqap-banks-bea-dc", (Object[])new Object[0]), (String)tran_falg, (String)ret_msg_1);
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public static EBBankBalanceResponse parseBalance(BankBalanceRequest request, String responseStr) {
        responseStr = responseStr.replace("<RETURN_MESSAGE>", "").replace("</RETURN_MESSAGE>", "");
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element opRep = JDomUtils.getChildElement((Element)root, (String)"opRep");
        String retCode = JDomUtils.getChildText((Element)opRep, (String)"retCode");
        String errMsg = JDomUtils.getChildText((Element)opRep, (String)"errMsg");
        if (!"000000".equals(retCode)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)retCode, (String)errMsg));
        }
        Element opResultSet = JDomUtils.getChildElement((Element)opRep, (String)"opResultSet");
        Element opResult = JDomUtils.getChildElement((Element)opResultSet, (String)"opResult");
        String ledger_bal = JDomUtils.getChildText((Element)opResult, (String)"LEDGER_BAL");
        String actual_bal = JDomUtils.getChildText((Element)opResult, (String)"ACTUAL_BAL");
        ArrayList<BalanceInfo> balanceInfoList = new ArrayList<BalanceInfo>(10);
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(request.getAcnt());
        if (StringUtils.isNotEmpty((String)ledger_bal)) {
            balanceInfo.setCurrentBalance(new BigDecimal(ledger_bal).divide(new BigDecimal("100"), 2, 0));
        } else {
            balanceInfo.setError(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\u3002", (String)"BalanceUtils_0", (String)"ebg-aqap-banks-bea-dc", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)actual_bal)) {
            balanceInfo.setAvailableBalance(new BigDecimal(actual_bal).divide(new BigDecimal("100"), 2, 0));
        }
        balanceInfo.setBankCurrency(request.getBankCurrency());
        balanceInfoList.add(balanceInfo);
        EBBankBalanceResponse ebBankBalanceResponse = new EBBankBalanceResponse(balanceInfoList);
        return ebBankBalanceResponse;
    }
}

