/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sxnxs.dc.services.payment;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sxnxs.dc.services.payment.QryPaymentImpl;
import kd.ebg.aqap.banks.sxnxs.dc.services.utils.AmountUtil;
import kd.ebg.aqap.banks.sxnxs.dc.services.utils.MessageUtil;
import kd.ebg.aqap.banks.sxnxs.dc.services.utils.ParserRsp;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.route.PayTypeEnum;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u7b14\u4ed8\u6b3e\u3002", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-sxnxs-dc", (Object[])new Object[0]));
        }
        Element Request = MessageUtil.getHead((String)"101101", (String)"YQBC02", (String)paymentInfo.getBankBatchSeqId());
        Element Body = new Element("Body");
        JDomUtils.addChild((Element)Body, (String)"transType", (String)(paymentInfo.is2SameBank() ? "1" : "2"));
        JDomUtils.addChild((Element)Body, (String)"PayerAcctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)Body, (String)"PayerAcctName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)Body, (String)"Amount", (String)AmountUtil.getAmountToBank(paymentInfo.getAmount()));
        JDomUtils.addChild((Element)Body, (String)"PayeeAcctNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)Body, (String)"PayeeName", (String)paymentInfo.getIncomeAccName());
        if (!paymentInfo.is2SameBank()) {
            JDomUtils.addChild((Element)Body, (String)"PayeeBankName", (String)paymentInfo.getIncomeBankName());
            JDomUtils.addChild((Element)Body, (String)"PayeeBankNo", (String)paymentInfo.getIncomeCnaps());
        }
        JDomUtils.addChild((Element)Body, (String)"AgentFlag", (String)"1");
        JDomUtils.addChild((Element)Request, (Element)Body);
        String encoding = RequestContextUtils.getCharset();
        String xml = JDomUtils.root2String((Element)Request, (String)encoding);
        return MessageUtil.getSendMsg((String)xml);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        BankResponse res = ParserRsp.parseRsp((String)s);
        if (!"S".equals(res.getResponseCode()) && !"D".equals(res.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)res.getResponseCode(), (String)res.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u8bf7\u6c42\u5df2\u7ecf\u63d0\u4ea4\uff0c\u94f6\u884c\u7cfb\u7edf\u5df2\u7ecf\u53d7\u7406\u3002", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-sxnxs-dc", (Object[])new Object[0]), (String)res.getResponseCode(), (String)res.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "101101";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        if ((PayTypeEnum.PAY_FOR_CAPITAL_ALLOCATION.getName().equalsIgnoreCase(paymentInfo.getSubBizType()) || UseConvertor.isTransfer((PaymentInfo)paymentInfo)) && !paymentInfo.is2SameBank()) {
            return true;
        }
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType());
    }
}

