/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.psbc.dc.service.detail;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.psbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.psbc.dc.Packer;
import kd.ebg.aqap.banks.psbc.dc.Parser;
import kd.ebg.aqap.banks.psbc.dc.service.detail.DetailPage;
import kd.ebg.aqap.banks.psbc.dc.util.DomHelper;
import kd.ebg.aqap.banks.psbc.dc.util.PsbcSocketUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailPageImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailPageImpl.class);
    private static final String PAGE_SIZE = "500";
    private static final String DETAIL_PAGE_TRANS_CODE = "3108";

    public boolean match(BankDetailRequest request) {
        return BankBusinessConfig.isDetailWithPage();
    }

    public EBBankDetailResponse doBiz(BankDetailRequest request) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(1);
        try {
            DetailPage page = new DetailPage();
            String pageTag = page.getFirstPageTag();
            String rspStr = null;
            String bizSeqId = request.getHeader().getBizSeqID();
            do {
                String rqstStr = this.packDetail(request, pageTag);
                super.setDetailImpl();
                ConnectionFactory factory = this.getConnectionFactory();
                IConnection conn = this.getConnection(factory);
                this.openConnection(conn);
                try (OutputStream os = this.getOutputStream(conn);){
                    this.send(os, rqstStr);
                    try (InputStream is = this.getInputStream(conn);){
                        rspStr = this.recv(is, bizSeqId);
                        this.logger.info(rspStr);
                        detailList.addAll(this.parseDetail(request, rspStr));
                        pageTag = page.getNextPageTag(rspStr);
                    }
                }
            } while (!page.isLastPage(pageTag));
            return new EBBankDetailResponse(detailList);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String recv(InputStream inputStream, String bizSeqId) {
        byte[] bytes = PsbcSocketUtil.readTcpByte((InputStream)inputStream, (String)"10", (String)RequestContextUtils.getCharset());
        String rspStr = "";
        try {
            rspStr = new String(bytes, RequestContextUtils.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u96c6", (Throwable)e);
        }
        return rspStr;
    }

    private String packDetail(BankDetailRequest request, String pageTag) {
        Element root = Packer.createReqRootElement((String)DETAIL_PAGE_TRANS_CODE);
        Element Param = JDomUtils.addChild((Element)root, (String)"Param");
        JDomUtils.addChild((Element)Param, (String)"Query_Account", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Param, (String)"Begin_Date", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)Param, (String)"End_Date", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)Param, (String)"PageNo", (String)pageTag);
        JDomUtils.addChild((Element)Param, (String)"PageNum", (String)PAGE_SIZE);
        JDomUtils.addChild((Element)Param, (String)"Reserved1", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved2", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved3", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved4", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2String((Element)root, (String)encoding);
        return Packer.createCommonMsg((String)xmlStr);
    }

    private List<DetailInfo> parseDetail(BankDetailRequest request, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.checkResponse(root, ResManager.loadKDString((String)"\u6307\u5b9a\u65e5\u671f\u4ea4\u6307\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailPageImpl_0", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
        if (!"00".equalsIgnoreCase(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u8d26\u53f7%1$s\u4ea4\u6613\u660e\u7ec6\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u4ea4\u6613\u72b6\u6001[%2$s]\u3002", (String)"DetailPageImpl_17", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), request.getAcnt().getAccNo(), StringUtils.catWithSpace((String[])new String[]{bankResponse.getResponseCode(), bankResponse.getResponseMessage()})));
        }
        Element Param = DomHelper.getChildElementNotNull(root, "Param");
        List RecordSet = Param.getChildren("RecordSet");
        if (RecordSet.size() == 0) {
            return Lists.newArrayListWithCapacity((int)1);
        }
        ArrayList<DetailInfo> totalList = new ArrayList<DetailInfo>(16);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < RecordSet.size(); ++i) {
            try {
                DetailInfo detail;
                String Remark;
                String Usage;
                String Trans_Date;
                String Flag;
                String Balance;
                String Amount;
                Element record;
                block22: {
                    record = (Element)RecordSet.get(i);
                    String Name = DomHelper.getChildTextNullAsBlank(record, "Name");
                    String Account = DomHelper.getChildTextNullAsBlank(record, "Account");
                    String Bank = DomHelper.getChildTextNullAsBlank(record, "Bank");
                    Amount = DomHelper.getChildTextNullAsBlank(record, "Amount");
                    Balance = DomHelper.getChildTextNullAsBlank(record, "Balance");
                    Flag = DomHelper.getChildTextNullAsBlank(record, "Flag");
                    Trans_Date = DomHelper.getChildTextNullAsBlank(record, "Trans_Date");
                    String Trans_Time = DomHelper.getChildTextNullAsBlank(record, "Trans_Time");
                    Usage = DomHelper.getChildTextNullAsBlank(record, "Usage");
                    Remark = DomHelper.getChildTextNullAsBlank(record, "Remark");
                    detail = new DetailInfo();
                    detail.setAccNo(request.getAcnt().getAccNo());
                    detail.setAccName(request.getAcnt().getAccName());
                    detail.setOppAccNo(Account);
                    detail.setOppAccName(Name);
                    detail.setOppBankName(Bank);
                    detail.setCurrency(request.getBankCurrency());
                    try {
                        if (!StringUtils.isEmpty((String)Trans_Date)) {
                            if (!StringUtils.isEmpty((String)Trans_Time)) {
                                detail.setTransDate(LocalDate.parse(Trans_Date, DateTimeFormatter.ofPattern("yyyyMMdd")));
                                detail.setTransTime(LocalDateTime.parse(Trans_Date + Trans_Time, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                            } else {
                                detail.setTransDate(LocalDate.parse(Trans_Date, DateTimeFormatter.ofPattern("yyyyMMdd")));
                                detail.setTransTime(LocalDateTime.parse(Trans_Date + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                            }
                            break block22;
                        }
                        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u63d0\u4f9b\u8f6c\u8d26\u65e5\u671f\uff0c\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u65e5\u671f\u3002", (String)"DetailPageImpl_13", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
                    }
                    catch (Exception e) {
                        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff1a%s\u3002", (String)"DetailPageImpl_19", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
                    }
                }
                if ("1".equalsIgnoreCase(Flag)) {
                    detail.setCreditAmount(BigDecimalHelper.div((String)Amount, (String)"100.00"));
                    detail.setDebitAmount(new BigDecimal("0.00"));
                } else if ("0".equalsIgnoreCase(Flag)) {
                    detail.setCreditAmount(new BigDecimal("0.00"));
                    detail.setDebitAmount(BigDecimalHelper.div((String)Amount, (String)"100.00"));
                } else {
                    this.logger.info("\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u501f\u8d37\u6807\u5fd7:{}", (Object)Flag);
                    continue;
                }
                if (!"".equals(Balance)) {
                    detail.setBalance(BigDecimalHelper.div((String)Balance, (String)"100.00"));
                }
                detail.setExplanation(Usage);
                if (!StringUtils.isEmpty((String)Remark)) {
                    int index = Remark.indexOf("_KD_");
                    if (index != -1) {
                        String bankDetailSeqId = BizNoUtil.getId((String)Remark);
                        String remark = BizNoUtil.getMsg((String)Remark);
                        detail.setKdFlag(bankDetailSeqId);
                        detail.setPayBankDetailSeqID(bankDetailSeqId);
                        if (StringUtils.isEmpty((String)detail.getExplanation())) {
                            detail.setExplanation(remark);
                        }
                        DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)bankDetailSeqId);
                    } else if (StringUtils.isEmpty((String)detail.getExplanation())) {
                        detail.setExplanation(Remark);
                    }
                }
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(record);
                detail.setJsonMap(jsonStr);
                String accNo = request.getAcnt().getAccNo();
                String transDate = Trans_Date;
                String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detail.setReceiptNo(receiptNo);
                totalList.add(detail);
                continue;
            }
            catch (Exception e) {
                this.logger.info("\u7b2c{}\u6761\u660e\u7ec6\u89e3\u6790\u5f02\u5e38\uff1a{}", new Object[]{i, e.getMessage()});
            }
        }
        return totalList;
    }

    public String pack(BankDetailRequest request) {
        return null;
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        return null;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return DETAIL_PAGE_TRANS_CODE;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6307\u5b9a\u65e5\u671f\u4ea4\u6613\u660e\u7ec6\u5206\u9875\u67e5\u8be2\uff083108\uff09\u3002", (String)"DetailPageImpl_16", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

