/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.psbc.dc.service.payment.batch.company;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.psbc.dc.Packer;
import kd.ebg.aqap.banks.psbc.dc.service.payment.PayParser;
import kd.ebg.aqap.banks.psbc.dc.service.payment.batch.FilePacker;
import kd.ebg.aqap.banks.psbc.dc.service.payment.batch.company.BatchCompanyQueryPayImPl;
import kd.ebg.aqap.banks.psbc.dc.util.CommonFileUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchCompanyPayImpl
extends AbstractPayImpl
implements IPay {
    private static final Logger log = LoggerFactory.getLogger(BatchCompanyPayImpl.class);

    public int getBatchSize() {
        return 500;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return BatchCompanyQueryPayImPl.class;
    }

    public String getDeveloper() {
        return "Jimmy";
    }

    public String getBizCode() {
        return "2025";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u5bf9\u516c\u652f\u4ed8", (String)"BatchCompanyPayImpl_1", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo info = paymentInfos[0];
        String fileName = FilePacker.get2025FileName((PaymentInfo)info);
        String content = FilePacker.pack2025File((PaymentInfo[])paymentInfos);
        log.info("2025\u63a5\u53e3\u6253\u5305\u6587\u4ef6\u540d:" + fileName);
        log.info("2025\u63a5\u53e3\u6253\u5305\u6587\u4ef6\u5185\u5bb9:" + content);
        try {
            new CommonFileUtils().uploadFile(fileName, content);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"2025\u4e0a\u4f20\u6279\u91cf\u4ee3\u53d1\u6587\u4ef6\u5931\u8d25\u3002", (String)"BatchCompanyPayImpl_2", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), (Throwable)e);
        }
        Element root = Packer.createReqRootElement((String)"2025");
        Element Param = JDomUtils.addChild((Element)root, (String)"Param");
        JDomUtils.addChild((Element)Param, (String)"Cust_Acct", (String)info.getAccNo());
        JDomUtils.addChild((Element)Param, (String)"Merch_Id", (String)RequestContextUtils.getBankParameterValue((String)"groupNum"));
        JDomUtils.addChild((Element)Param, (String)"Ope_Code", (String)"??");
        JDomUtils.addChild((Element)Param, (String)"File_Name", (String)fileName);
        JDomUtils.addChild((Element)Param, (String)"Reserved1", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved2", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved3", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved4", (String)"");
        for (int i = 0; i < paymentInfos.length; ++i) {
            PaymentInfoSysFiled.set((PaymentInfo)paymentInfos[i], (String)"fileName", (String)fileName);
        }
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2String((Element)root, (String)encoding);
        return Packer.createCommonMsg((String)xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return new PayParser().parser(request, responseStr);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

