/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.psbc.dc.service.payment.batch.company;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.psbc.dc.Packer;
import kd.ebg.aqap.banks.psbc.dc.Parser;
import kd.ebg.aqap.banks.psbc.dc.util.DomHelper;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchCompanyQueryPayImPl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final Logger log = LoggerFactory.getLogger(BatchCompanyQueryPayImPl.class);

    public int getBatchSize() {
        return 500;
    }

    public String getDeveloper() {
        return "Jimmy";
    }

    public String getBizCode() {
        return "2026";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u5bf9\u516c\u652f\u4ed8", (String)"BatchCompanyQueryPayImPl_1", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo info = paymentInfos[0];
        Element root = Packer.createReqRootElement((String)"2026");
        Element Param = JDomUtils.addChild((Element)root, (String)"Param");
        String fileName = PaymentInfoSysFiled.get((PaymentInfo)info, (String)"fileName");
        if (StringUtils.isEmpty((String)fileName)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u6587\u4ef6\u540dFile_Name\u4e3a\u7a7a\u3002", (String)"BatchCompanyQueryPayImPl_10", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)Param, (String)"File_Name", (String)fileName);
        JDomUtils.addChild((Element)Param, (String)"Batch_No", (String)info.getBankBatchSeqId());
        Element recordSet = JDomUtils.addChild((Element)Param, (String)"RecordSet");
        for (PaymentInfo payInfo : paymentInfos) {
            JDomUtils.addChild((Element)recordSet, (String)"Seq_No", (String)payInfo.getBankDetailSeqId());
        }
        JDomUtils.addChild((Element)Param, (String)"Reserved1", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved2", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved3", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved4", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2String((Element)root, (String)encoding);
        return Packer.createCommonMsg((String)xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.checkResponse(root, ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u67e5\u8be2", (String)"BatchCompanyQueryPayImPl_2", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
        if (!"00".equalsIgnoreCase(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7684\u4ea4\u6613\u72b6\u6001\u3002", (String)"BatchCompanyQueryPayImPl_3", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u94f6\u884c\u54cd\u5e94\u7801\uff1a%1$s\u94f6\u884c\u54cd\u5e94\u6d88\u606f\uff1a%2$s\u3002", (String)"BatchCompanyQueryPayImPl_12", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage()));
        }
        Element Param = DomHelper.getChildElementNotNull(root, "Param");
        List recordSets = Param.getChildren("RecordSet");
        for (Element node : recordSets) {
            String Result = DomHelper.getChildTextNotNull(node, "Result", ResManager.loadKDString((String)"\u63a5\u6536\u8f6c\u8d26\u6307\u4ee4\u7ed3\u679c\u3002", (String)"BatchCompanyQueryPayImPl_7", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
            String Bank_Serial = DomHelper.getChildText(node, "Bank_Serial");
            String Trans_Date = DomHelper.getChildText(node, "Book_Date");
            String seqNo = JDomUtils.getChildText((Element)node, (String)"Seq_No");
            log.info("Bank_Serial(\u8f6c\u8d26\u94f6\u884c\u6d41\u6c34\u53f7):" + Bank_Serial);
            log.info("Book_Date(\u8bb0\u8d26\u65e5\u671f):" + Trans_Date);
            PaymentInfo info = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)seqNo);
            if (null == info) continue;
            if ("0".equalsIgnoreCase(Result)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)"", (String)Result, (String)ResManager.loadKDString((String)"\u5931\u8d25", (String)"BatchCompanyQueryPayImPl_8", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
                continue;
            }
            if ("1".equalsIgnoreCase(Result)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)"", (String)Result, (String)ResManager.loadKDString((String)"\u6210\u529f", (String)"BatchCompanyQueryPayImPl_9", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u94f6\u4f01\u672a\u80fd\u7406\u89e3\u7684\u4ea4\u6613\u72b6\u6001\u7801:%s,\u8bf7\u5411\u94f6\u884c\u53cd\u9988\u3002", (String)"BatchCompanyQueryPayImPl_13", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), Result), (String)"", (String)"");
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

