/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.psbc.dc.service.payment.income;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.psbc.dc.Packer;
import kd.ebg.aqap.banks.psbc.dc.service.payment.PayParser;
import kd.ebg.aqap.banks.psbc.dc.service.payment.income.IncomeQueryPayImpl;
import kd.ebg.aqap.banks.psbc.dc.util.PackerUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class IncomePayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return IncomeQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "2009";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u884c\u5185\u6536\u6b3e", (String)"IncomePayImpl_1", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "income".equalsIgnoreCase(paymentInfo.getSubBizType());
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5355\u7b14\u884c\u5185\u6536\u6b3e(2009)\u4e0d\u652f\u6301\u6279\u91cf\u3002", (String)"IncomePayImpl_2", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = paymentInfos[0];
        Element root = Packer.createReqRootElement((String)"2009");
        Element Param = JDomUtils.addChild((Element)root, (String)"Param");
        JDomUtils.addChild((Element)Param, (String)"Pay_Account", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)Param, (String)"Pay_Name", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)Param, (String)"Rec_Name", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)Param, (String)"Rec_Account", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)Param, (String)"Amount", (String)PackerUtils.convertYuan2CentStr((BigDecimal)paymentInfo.getAmount()));
        JDomUtils.addChild((Element)Param, (String)"Currency", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)Param, (String)"EnterpriseID", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)Param, (String)"VoucherID", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Area_Code", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Usage", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Abs_Code", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Remark", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)Param, (String)"Reserved1", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved2", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved3", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved4", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2String((Element)root, (String)encoding);
        return Packer.createCommonMsg((String)xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return new PayParser().parser(request, responseStr);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

