/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.psbc.dc.util;

import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.commons.codec.binary.Base64;
import org.jdom2.Element;

public class CommonFileUtils {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CommonFileUtils.class);
    public static final String BIZ_SUCCESS = "BIZ_SUCCESS";
    private static String uploadFile = "uploadFile";
    private static String downloadFile = "downloadFile";

    public static String sendAndRecv(String url, String param) {
        String ip = RequestContextUtils.getBankParameterValue((String)"frontProxy_ip");
        if (StringUtils.isEmpty((String)ip)) {
            ip = RequestContextUtils.getBankParameterValue((String)"ip");
        }
        String portStr = RequestContextUtils.getBankParameterValue((String)"frontProxy_port");
        String timeOutStr = RequestContextUtils.getBankParameterValue((String)"frontProxy_timeOut");
        int timeOut = Integer.parseInt(timeOutStr);
        if (timeOut == 0) {
            timeOut = 5;
        }
        String result = "";
        try {
            URL realUrl = new URL("http://" + ip + ":" + portStr + url);
            URLConnection conn = realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setConnectTimeout(1000 * timeOut * 60);
            try (PrintWriter out = new PrintWriter(conn.getOutputStream());){
                out.print(param);
                out.flush();
                try (InputStream in = conn.getInputStream();){
                    result = IOUtils.readFully((InputStream)in, (String)"GBK");
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            logger.info(e.toString());
        }
        return result;
    }

    public String uploadFile(String fileName, String fileContent) {
        try {
            String rqstStr = this.packUplaodFileXMLWithBase64Encoded(fileName, fileContent.getBytes("GBK"));
            String rspStr = CommonFileUtils.sendAndRecv("", rqstStr);
            return this.parseUplaodFileXML(rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    private String packUplaodFileXMLWithBase64Encoded(String fileName, byte[] fileContent) {
        Element simulator = JDomUtils.createRoot((String)"simulator");
        Element head = CommonFileUtils.createHead(uploadFile);
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"fileName", (String)fileName);
        JDomUtils.addChild((Element)reqPara, (String)"fileContent", (String)Base64.encodeBase64String((byte[])fileContent));
        return JDomUtils.root2String((Element)simulator, (String)"GBK");
    }

    private String parseUplaodFileXML(String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)"GBK");
        BankResponse rsp = CommonFileUtils.parseHeader(root);
        if (!BIZ_SUCCESS.equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38 \uff0c%1$s %2$s\u3002", (String)"CommonFileUtils_4", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        Element status = JDomUtils.getChildElementNotNull((Element)rspPara, (String)"status");
        String ReturnCode = JDomUtils.getChildTextTrimNotNull((Element)status, (String)"code", (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u7801", (String)"CommonFileUtils_1", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
        String ReturnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
        if (!BIZ_SUCCESS.equalsIgnoreCase(ReturnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25 \uff0c%1$s %2$s\u3002", (String)"CommonFileUtils_5", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), ReturnCode, ReturnMsg));
        }
        return ReturnCode;
    }

    public static Element createHead(String bizType) {
        return CommonFileUtils.createHead(bizType, Sequence.genSequence());
    }

    public static Element createHead(String bizType, String seqno) {
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"reqDate", (String)DateTimeUtils.formatDate((Date)new Date()));
        JDomUtils.addChild((Element)head, (String)"reqTime", (String)DateTimeUtils.formatTime((Date)new Date()));
        JDomUtils.addChild((Element)head, (String)"bizType", (String)bizType);
        JDomUtils.addChild((Element)head, (String)"sequence", (String)seqno);
        return head;
    }

    public static BankResponse parseHeader(Element root) {
        Element Head = JDomUtils.getChildElementNotNull((Element)root, (String)"head");
        String IBSReturnCode = JDomUtils.getChildTextNotNull((Element)Head, (String)"rspcode", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u7801", (String)"CommonFileUtils_3", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
        String IBSReturnMsg = JDomUtils.getChildTextNullAsBlank((Element)Head, (String)"rspMsg");
        BankResponse response = new BankResponse();
        response.setResponseCode(IBSReturnCode);
        response.setResponseMessage(IBSReturnMsg);
        return response;
    }
}

