/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zjrc.dc.services.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zjrc.dc.services.ZJRC_DC_Packer;
import kd.ebg.aqap.banks.zjrc.dc.services.ZJRC_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest request) {
        Element root = ZJRC_DC_Packer.getCommonHeader("100001", Sequence.genSequence());
        Element reqBody = JDomUtils.addChild((Element)root, (String)"reqBody");
        Element iAccAll = JDomUtils.addChild((Element)reqBody, (String)"iAccAll");
        Element row = JDomUtils.addChild((Element)iAccAll, (String)"row");
        request.getBankAcntList().forEach(acnt -> JDomUtils.addChild((Element)row, (String)"accountNo", (String)acnt.getAccNo()));
        JDomUtils.addChild((Element)row, (String)"currencyType", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)row, (String)"accountType", (String)"1");
        return ZJRC_DC_Packer.getPostParams(root, this.getBizCode());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = ZJRC_DC_Parser.parserCommonInfo(root);
        if (!bankResponse.getResponseCode().equals("0000")) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff0c%s\u3002", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), bankResponse.getResponseMessage()));
        }
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"resBody");
        Element accList = JDomUtils.getChildElement((Element)resBody, (String)"accList");
        List rowList = accList.getChildren("row");
        if (rowList.size() != 0) {
            String accNo = request.getAcnt().getAccNo();
            boolean flag = rowList.stream().allMatch(row -> accNo.equals(JDomUtils.getChildText((Element)row, (String)"accNo")));
            if (!flag) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bf7\u6c42\u8d26\u53f7\u4e0e\u94f6\u884c\u54cd\u5e94\u7684\u8d26\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]));
            }
            ArrayList<BalanceInfo> banBalanceInfos = new ArrayList<BalanceInfo>(16);
            for (int j = 0; j < rowList.size(); ++j) {
                String amount = JDomUtils.getChildText((Element)((Element)rowList.get(j)), (String)"amount");
                String balanceAvailable = JDomUtils.getChildText((Element)((Element)rowList.get(j)), (String)"balanceAvailable");
                BalanceInfo balanceInfo = new BalanceInfo();
                balanceInfo.setBankAcnt(request.getAcnt());
                balanceInfo.setBankCurrency(request.getBankCurrency());
                balanceInfo.setBalanceDateTime(LocalDateTime.now());
                this.setCurrentBalance(balanceInfo, amount);
                if (!StringUtils.isEmpty((String)balanceAvailable)) {
                    balanceInfo.setAvailableBalance(new BigDecimal(balanceAvailable));
                }
                banBalanceInfos.add(balanceInfo);
            }
            return new EBBankBalanceResponse(banBalanceInfos);
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25,\u539f\u56e0:\u94f6\u884c\u672a\u8fd4\u56de\u4f59\u989d\u4fe1\u606f", (String)"TodayBalanceImpl_2", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]));
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "100001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u65e5\u4f59\u989d", (String)"TodayBalanceImpl_3", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
    }
}

