/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zjrc.dc.services.payment.batch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zjrc.dc.services.ZJRC_DC_Packer;
import kd.ebg.aqap.banks.zjrc.dc.services.ZJRC_DC_Parser;
import kd.ebg.aqap.banks.zjrc.dc.services.payment.BankResponseCodeUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BatchQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BatchQueryPayImpl.class);

    public int getBatchSize() {
        return 500;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Element root = ZJRC_DC_Packer.getCommonHeader("100009", Sequence.genSequence());
        Element reqBody = JDomUtils.addChild((Element)root, (String)"reqBody");
        JDomUtils.addChild((Element)reqBody, (String)"flowNoType", (String)"1");
        Element flowNoList = JDomUtils.addChild((Element)reqBody, (String)"flowNoList");
        Element row = JDomUtils.addChild((Element)flowNoList, (String)"row");
        JDomUtils.addChild((Element)row, (String)"orderFlowNo", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        return ZJRC_DC_Packer.getPostParams(root, this.getBizCode());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = ZJRC_DC_Parser.parserCommonInfo(root);
        if (!bankResponse.getResponseCode().equals("0000")) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5f02\u5e38", (String)"BatchQueryPayImpl_0", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        }
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"resBody");
        Element tranflowResultList = JDomUtils.getChildElement((Element)resBody, (String)"tranflowResultList");
        List rows = tranflowResultList.getChildren("row");
        Map<String, PaymentInfo> matchPaymentMap = this.getMatchPaymentMap(paymentInfos);
        for (int i = 0; i < rows.size(); ++i) {
            String orderFlowNo = ((Element)rows.get(i)).getChildTextTrim("orderFlowNo");
            String code = JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"state");
            String erroerMsg = JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"errorMessage");
            PaymentInfo paymentInfo = matchPaymentMap.get(orderFlowNo);
            if (paymentInfo == null) {
                this.logger.info("\u5f53\u524d\u660e\u7ec6\u6d41\u6c34{}\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u4ed8\u6b3e\u8bb0\u5f55", (Object)orderFlowNo);
                continue;
            }
            if (BankResponseCodeUtils.isSuccessed((String)code)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)code, (String)BankResponseCodeUtils.getResponseMsg((String)code), (String)erroerMsg);
                continue;
            }
            if (BankResponseCodeUtils.isFailed((String)code)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)code, (String)BankResponseCodeUtils.getResponseMsg((String)code), (String)erroerMsg);
                continue;
            }
            if (BankResponseCodeUtils.isSubmit((String)code)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)code, (String)erroerMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)code, (String)BankResponseCodeUtils.getResponseMsg((String)code), (String)erroerMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "100009";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u8f6c\u8d26\u4ed8\u6b3e\u67e5\u8be2\u3002", (String)"BatchQueryPayImpl_3", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
    }

    private Map<String, PaymentInfo> getMatchPaymentMap(List<PaymentInfo> paymentInfos) {
        HashMap<String, PaymentInfo> PaymentInfoMap = new HashMap<String, PaymentInfo>(16);
        for (PaymentInfo paymentInfo : paymentInfos) {
            PaymentInfoMap.put(paymentInfo.getBankRefID(), paymentInfo);
        }
        return PaymentInfoMap;
    }
}

