/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zjrc.dc.services.payment.company;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zjrc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.zjrc.dc.services.ZJRC_DC_Packer;
import kd.ebg.aqap.banks.zjrc.dc.services.ZJRC_DC_Parser;
import kd.ebg.aqap.banks.zjrc.dc.services.payment.company.CompanyQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryPayImpl.class;
    }

    public String pack(BankPayRequest request) {
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        Element root = ZJRC_DC_Packer.getCommonHeader("100005", request.getBankBatchSeqID());
        Element reqBody = JDomUtils.addChild((Element)root, (String)"reqBody");
        JDomUtils.addChild((Element)reqBody, (String)"payAccount", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)reqBody, (String)"payAccountName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)reqBody, (String)"currencyType", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)reqBody, (String)"payAmount", (String)paymentInfo.getAmount().toString());
        JDomUtils.addChild((Element)reqBody, (String)"payUse", (String)CompanyPayImpl.getExplanationForSalary(paymentInfo));
        JDomUtils.addChild((Element)reqBody, (String)"payRem", (String)paymentInfo.getUseCn());
        JDomUtils.addChild((Element)reqBody, (String)"recAccount", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)reqBody, (String)"recAccountName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)reqBody, (String)"recAccountOpenBank", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)reqBody, (String)"unionBankNo", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)reqBody, (String)"transferTowardType", (String)(paymentInfo.is2SameCity() ? "0" : "1"));
        if (BankBusinessConfig.isSupperTransfer(paymentInfo.getAccNo()) && paymentInfo.getAmount().compareTo(new BigDecimal("50000")) <= 0) {
            JDomUtils.addChild((Element)reqBody, (String)"ZHYODJ", (String)"2");
        } else {
            JDomUtils.addChild((Element)reqBody, (String)"ZHYODJ", (String)(paymentInfo.is2Urgent() ? "1" : "0"));
        }
        JDomUtils.addChild((Element)reqBody, (String)"feePayType", (String)BankBusinessConfig.getTransferFeeType(paymentInfo.getAccNo()));
        JDomUtils.addChild((Element)reqBody, (String)"tranMate", (String)(paymentInfo.is2Individual() ? "0" : "1"));
        return ZJRC_DC_Packer.getPostParams(root, this.getBizCode());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = ZJRC_DC_Parser.parserCommonInfo(root);
        if (!bankResponse.getResponseCode().equals("0000")) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5f02\u5e38", (String)"CompanyPayImpl_0", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyPayImpl_1", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"resBody");
        String comFlowNo = JDomUtils.getChildText((Element)resBody, (String)"commFlowNo");
        if (null == comFlowNo || "".equals(comFlowNo)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5f02\u5e38", (String)"CompanyPayImpl_0", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6307\u4ee4\u5e8f\u53f7\u672a\u77e5\uff0c\u5c06\u65e0\u6cd5\u83b7\u53d6\u4e1a\u52a1\u7ed3\u679c\u3002", (String)"CompanyPayImpl_2", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]));
        } else {
            PaymentInfoSysFiled.set((List)paymentInfos, (String)"comFlowNo", (String)comFlowNo);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public static String getExplanationForSalary(PaymentInfo info) {
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            return BizNoUtil.cont((String)info.getBankDetailSeqId(), (String)info.getExplanation());
        }
        return info.getExplanation();
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "100005";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u516c\u652f\u4ed8", (String)"CompanyPayImpl_3", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

