package kd.ebg.aqap.banks.jxnsb.cmp;
import kd.bos.dataentity.resource.ResManager;

import com.google.common.collect.Lists;
import kd.ebg.aqap.banks.jxnsb.cmp.services.balance.BalanceImpl;
import kd.ebg.aqap.banks.jxnsb.cmp.services.detail.DetailImpl;
import kd.ebg.aqap.banks.jxnsb.cmp.services.payment.PaymentImpl;
import kd.ebg.aqap.banks.jxnsb.cmp.services.payment.PretreatmentImpl;
import kd.ebg.aqap.banks.jxnsb.cmp.services.payment.QryPaymentImpl;
import kd.ebg.aqap.banks.jxnsb.cmp.services.payment.Salary.QrySalPaymentImpl;
import kd.ebg.aqap.banks.jxnsb.cmp.services.payment.Salary.SalaryPaymentImpl;
import kd.ebg.aqap.common.constant.DetailUniqueTypeEnum;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.aqap.common.framework.bank.meta.BankMetaDataCollector;
import kd.ebg.aqap.common.framework.bank.meta.template.FBEMetaDataTemplate;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JxnsbCmpMetaDataImpl extends FBEMetaDataTemplate implements BankMetaDataCollector {

    //金蝶代理服务器配置
    public static final String  frontProxy_port = "frontProxy_port";
    public static final String  frontProxy_timeOut = "frontProxy_timeOut";


    @Override
    public void baseConfigInit() {
        setExchangeProtocol(BankLoginConfigUtil.PROTOCOL_TCP);
        setTimeOut(3);
        setCharSet(BankLoginConfigUtil.CHARSET_GBK);
    }

    @Override
    public void metaDataInit() {
        setBankName(ResManager.loadKDString("江西农商行", "JxnsbCmpMetaDataImpl_0", "ebg-aqap-banks-jxnsb-cmp"));
        setBankVersionID("JXNSB_CMP");
        setBankShortName("JXNSB");
        setBankVersionName(ResManager.loadKDString("江西农商行现金管理平台", "JxnsbCmpMetaDataImpl_1", "ebg-aqap-banks-jxnsb-cmp"));
        setDescription(ResManager.loadKDString("江西农商行", "JxnsbCmpMetaDataImpl_0", "ebg-aqap-banks-jxnsb-cmp"));
        setKeyNames(Lists.newArrayList());
    }

    @Override
    public List<Class<? extends IBankService>> getBizImplClasses() {
        return Lists.newArrayList(
                BalanceImpl.class,
                DetailImpl.class,
                QrySalPaymentImpl.class,
                SalaryPaymentImpl.class,
                PaymentImpl.class,
                QryPaymentImpl.class,
                PretreatmentImpl.class
        );
    }

  /*  @Override
    public List<BankLoginConfig> getPgpConfigSupplement() {
        return Lists.newArrayList(
                //BankLoginConfigUtil.getMlBankLoginConfig("encodeLibPath",new MultiLangEnumBridge("动态库的绝对路径","JxnsbCmpMetaDataImpl_5","ebg-aqap-banks-jxnsb-cmp"), new MultiLangEnumBridge("银行提供的libhscrypt.so动态库的绝对路径","JxnsbCmpMetaDataImpl_6","ebg-aqap-banks-jxnsb-cmp"), "/mservice/lib/biz/libhscrypt.so", false, false),
                //BankLoginConfigUtil.getMlBankLoginConfig("publicKeyLibPath",new MultiLangEnumBridge("加密解密秘钥的文件路径,生产密钥在前置机安装路径下的Temp目录","",""), new MultiLangEnumBridge("银行提供的PUBLICKEY文件绝对路径","",""), "/mservice/lib/biz/PUBLICKEY.txt", false, false),
                BankLoginConfigUtil.getMlBankLoginConfig("secretKey", new MultiLangEnumBridge("秘钥文件","JxnsbCmpMetaDataImpl_7","ebg-aqap-banks-jxnsb-cmp"),new MultiLangEnumBridge("加密解密秘钥的文件,生产密钥在前置机安装路径下的Temp目录","JxnsbCmpMetaDataImpl_8","ebg-aqap-banks-jxnsb-cmp"),"",false,false, "upload")
               );
    }*/

    @Override
    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return Lists.newArrayList();
    }

    @Override
    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return Lists.newArrayList();
    }

    @Override
    public BankPropertyConfig getPropertyConfig() {
        return new BankBusinessConfig();
    }


    @Override
    public List<BankLoginConfig> getFrontProxyConfig() {
        return Lists.newArrayList(
                BankLoginConfigUtil.getMlBankLoginConfig(
                        frontProxy_port,
                        new MultiLangEnumBridge("金蝶代理服务端口号", "JxnsbCmpMetaDataImpl_2", "ebg-aqap-banks-jxnsb-cmp") ,
                        new MultiLangEnumBridge("金蝶前置代理开放的服务端口号", "JxnsbCmpMetaDataImpl_3", "ebg-aqap-banks-jxnsb-cmp") ,
                        "2313").set2Nullable(),
                BankLoginConfigUtil.getMlBankLoginConfig(BankLoginConfigUtil.FRONT_PROXY_PROTOCOL,this.getMlExProtocolName(), "HTTP", true, false).setHidden(true),
                BankLoginConfigUtil.getMlBankLoginConfig(BankLoginConfigUtil.frontProxy_timeOut, new MultiLangEnumBridge("金蝶代理服务器超时时间(单位：分钟)", "JxnsbCmpMetaDataImpl_4", "ebg-aqap-banks-jxnsb-cmp"), "5",false,false).set2Integer().setHidden(true)

                );
    }

    @Override
    public Map<String, String> getDetailUniqueRule(){
        // 交易明细银行主键：账号+交易日期（tr_acdt）+主机流水号（host_serial_no）+借方金额（rcvamt）+贷方金额（payamt）
        Map<String, String> result = new LinkedHashMap<>(16); // 一定要用LinkedHashMap，这样遍历的时候才是插入顺序
        // 账号字段是固定的，不从报文里拿，照写即可，其他字段需要注意区分大小写！！！其他字段需要注意区分大小写！！！其他字段需要注意区分大小写！！！
        result.put("accNo", DetailUniqueTypeEnum.STRING.getType());
        result.put("tr_acdt", DetailUniqueTypeEnum.STRING.getType());     // 日期字段是经过处理的，手动添加的
        result.put("host_serial_no", DetailUniqueTypeEnum.STRING.getType());
        result.put("rcvamt", DetailUniqueTypeEnum.STRING.getType());
        result.put("payamt", DetailUniqueTypeEnum.STRING.getType());
        return result;
    }
}
