package kd.ebg.aqap.banks.jxnsb.cmp.services;

import com.grapecity.documents.excel.S;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

import java.util.Date;

public class Packer implements Constants{
    /**
     * 封装--公共请求头
     * @param tr_code 交易码
     * @param req_no  请求号
     * @param file_flag 文件标识:0-报文,1-文件
     * @return
     */
    public static Element createCommonHead(String tr_code , String req_no, String file_flag){
        Element ap = JDomUtils.createRoot(Constants.XML_ap);
        Element head = JDomUtils.addChild(ap, Constants.XML_head);

        JDomUtils.addChild(head, Constants.XML_tr_code,tr_code); // 交易码
        JDomUtils.addChild(head, Constants.XML_cms_corp_no, ""); // 现金管理客户号
        JDomUtils.addChild(head, Constants.XML_user_no, ""); // 用户号
        JDomUtils.addChild(head, Constants.XML_org_code,  ""); // 机构号
        JDomUtils.addChild(head, Constants.XML_serial_no, ""); // 交易流水号
        JDomUtils.addChild(head, Constants.XML_req_no, req_no); // 请求号
        Date d = new Date();
        JDomUtils.addChild(head, Constants.XML_tr_acdt,
                DateTimeUtils.format(d, Constants.Format_reqDate)); // 交易日期
        JDomUtils.addChild(head, Constants.XML_tr_time,
                DateTimeUtils.format(d, Constants.Format_reqTime)); // 交易时间
        JDomUtils.addChild(head, Constants.XML_channel, "5"); // 渠道标识
        JDomUtils.addChild(head, Constants.XML_sign, ""); // 签名标识
        JDomUtils.addChild(head, Constants.XML_file_flag, file_flag); // 文件标识:0-报文,1-文件
        JDomUtils.addChild(head, Constants.XML_reserved, ""); // 保留字段

        JDomUtils.addChild(ap, Constants.XML_body); // 该节点在各业务接口中在进行填充（相当body内容）
        return ap;
    }

   /* public static String packRequestMsg(String trans_code,String signData){
        StringBuilder buffer = new StringBuilder();
        buffer.append(trans_code);
        buffer.append("|#");
        buffer.append(signData);
        return buffer.toString();
    }*/
}
