package kd.ebg.aqap.banks.jxnsb.cmp.services.balance;

import com.google.common.collect.Lists;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jxnsb.cmp.services.Common;
import kd.ebg.aqap.banks.jxnsb.cmp.services.Constants;
import kd.ebg.aqap.banks.jxnsb.cmp.services.Packer;
import kd.ebg.aqap.banks.jxnsb.cmp.services.utils.EncodeAnDecodeHandler;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class BalanceImpl extends AbstractBalanceImpl implements IBalance, Constants {

    EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    @Override
    public String getDeveloper() {
        return "";
    }

    @Override
    public String getBizCode() {
        return Constants.CODE_QueryBalance;
    }

    @Override
    public String getBizDesc() {
        return ResManager.loadKDString("查询账户核心余额 (200108)", "BalanceImpl_0", "ebg-aqap-banks-jxnsb-cmp");
    }


    @Override
    public String pack(BankBalanceRequest req) {
        BankAcnt acnt = req.getAcnt();
        String req_no = RequestContextUtils.getRequestContext()
                .getBankRequestSeq();
        // 查询账户余额 (200108交易)
        String tr_code = Constants.CODE_QueryBalance;

        Element ap = Packer.createCommonHead(tr_code, req_no, "0"); // 报文头
        Element body = ap.getChild(Constants.XML_body);

        JDomUtils.addChild(body, "acno", acnt.getAccNo()); // 账号
        JDomUtils.addChild(body, "cur_code", req.getBankCurrency()); // 币种

        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils
                .root2StringWithoutXMLDeclaration(ap, encoding);
        xmlMsg = EncodeAnDecodeHandler.encode(xmlMsg);
        xmlMsg = Common.createCommonMsg(xmlMsg);
        return xmlMsg;
    }

    @Override
    public EBBankBalanceResponse parse(BankBalanceRequest req, String rspStr) {
        rspStr = EncodeAnDecodeHandler.decode(rspStr);
        Element ap = JDomUtils.string2Root(rspStr, RequestContextUtils.getCharset());

        Element head = ap.getChild(Constants.XML_head);
        BankResponse response = Common.parseBankResponse(head);
        if (!"0_0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString("余额查询失败，原因：%1$s,%2$s", "BalanceImpl_2", "ebg-aqap-banks-jxnsb-cmp")
                    , response.getResponseCode() , response.getResponseMessage()));
        }

        String tr_acdt = head.getChildTextTrim(Constants.XML_tr_acdt);
        String tr_time = head.getChildTextTrim(Constants.XML_tr_time);

        Element body = ap.getChild(Constants.XML_body);

		String acno = body.getChildTextTrim("acno");// 账号
	    String cur_code = body.getChildTextTrim("cur_code");// 币种
//		String acname = body.getChildTextTrim("acname");// 户名
        String balance = body.getChildTextTrim("balance");// 余额
        String use_balance = body.getChildTextTrim("use_balance");// 可用余额
//		String freeze_bal = body.getChildTextTrim("freeze_bal");// 冻结金额


        String bankCurrency  = StringUtils.isEmpty(cur_code) ? req.getBankCurrency() :cur_code;
        String accountNo = StringUtils.isEmpty(acno) ? req.getAcnt().getAccNo() : acno;
        BalanceInfo balanceInfo = new BalanceInfo();

        setBankAcnt(balanceInfo,req.getBankAcntList(),accountNo);
        setBankCurrency(balanceInfo,bankCurrency);

        balanceInfo.setBalanceDateTime(LocalDateTime.parse(tr_acdt + tr_time, DateTimeFormatter.ofPattern(Constants.Format_reqDateTime)));
        setCurrentBalance(balanceInfo,balance);

        if (!StringUtils.isEmpty(use_balance)) {
            balanceInfo.setAvailableBalance(new BigDecimal(use_balance));
        }
        return new EBBankBalanceResponse(Lists.newArrayList(balanceInfo));
    }

    @Override
    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg(super.recv(inputStream));
    }

}
