package kd.ebg.aqap.banks.jxnsb.cmp.services.detail;
import com.google.common.collect.Maps;
import kd.bos.dataentity.resource.ResManager;

import com.alibaba.fastjson.JSONObject;
import kd.ebg.aqap.banks.jxnsb.cmp.services.Common;
import kd.ebg.aqap.banks.jxnsb.cmp.services.Constants;
import kd.ebg.aqap.banks.jxnsb.cmp.services.Packer;
import kd.ebg.aqap.banks.jxnsb.cmp.services.utils.EncodeAnDecodeHandler;
import kd.ebg.aqap.banks.jxnsb.cmp.services.proxy.FileDownLoad;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.egf.common.cache.CosmicConstants;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.aqap.common.model.DetailInfo;
import org.jdom2.Element;

import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DetailImpl extends AbstractDetailImpl implements IDetail, IHisDetail {

     private final static EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);


    @Override
    public String getDeveloper() {
        return "HSQ";
    }

    @Override
    public String getBizCode() {
        return Constants.CODE_QueryDetail;
    }

    @Override
    public String getBizDesc() {
        return ResManager.loadKDString("IESI109012，账户明细查询。", "DetailImpl_0", "ebg-aqap-banks-jxnsb-cmp");
    }

    @Override
    public String pack(BankDetailRequest rqst) {
        BankAcnt acnt = rqst.getAcnt();

        String req_no = RequestContextUtils.getRequestContext().getBankRequestSeq();
        // 查询账户明细(200110交易)
        String tr_code = Constants.CODE_QueryDetail;

        Element ap = Packer.createCommonHead(tr_code, req_no,"0"); // 报文头
        Element body = ap.getChild("body");

        JDomUtils.addChild(body, "acno", acnt.getAccNo()); // 账号
        JDomUtils.addChild(body, "cur_code", rqst.getBankCurrency()); // 币种
        JDomUtils.addChild(body, "start_date", rqst.getStartDate().format(DateTimeFormatter.ofPattern(Constants.Format_reqDate))); // 起始日期YYYYMMDD
        JDomUtils.addChild(body, "end_date", rqst.getEndDate().format(DateTimeFormatter.ofPattern(Constants.Format_reqDate)));// 终止日期YYYYMMDD

        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration(ap, encoding);
        xmlMsg = EncodeAnDecodeHandler.encode(xmlMsg);
        return Common.createCommonMsg(xmlMsg);
    }

    @Override
    public EBBankDetailResponse parse(BankDetailRequest rqst, String rspStr) {
        //FileUtil fileUtil = new FileUtil();
        rspStr = EncodeAnDecodeHandler.decode(rspStr);
        List<DetailInfo> details = new ArrayList<>(8);

        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root(rspStr, encoding);

        Element head = ap.getChild(Constants.XML_head);
        Element body = ap.getChild(Constants.XML_body);
        BankResponse response = Common.parseBankResponse(head);
        if (!"0_0000".equals(response.getResponseCode())) {
           throw  EBExceiptionUtil.serviceException(ShowTipUtil.getResponseErrorTips(response.getResponseCode(),response.getResponseMessage()));
        }

        String record_num = body.getChildTextTrim(Constants.XML_record_num);
        String field_num = body.getChildTextTrim(Constants.XML_field_num);

        int recordNum = -1;
        if (!StringUtils.isEmpty(record_num)) {
            recordNum = Integer.parseInt(record_num);
        }

        int fieldNum = -1;
        if (!StringUtils.isEmpty(field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }

        if (recordNum <= 0) {
            log.error("本次交易明细查询返回结果为空，无交易明细。");
            return new EBBankDetailResponse(details);
        }
        String file_flag = head.getChildTextTrim(Constants.XML_file_flag);// 0-报文1-文件
        String content = "";

        if ("1".equals(file_flag)) {// 文件
            log.info("本次交易明细查询返回'文件'");
            String file_name = body.getChildTextTrim(Constants.XML_file_name);
            try {
                // 下载文件 TODO 需要代理程序
                //content = fileUtil.downloadFile(file_name);
                content = new FileDownLoad().doBiz(file_name);
            } catch (Exception e) {
                throw EBExceiptionUtil.serviceException(ResManager.loadKDString("[查询交易明细]获取文件失败。", "DetailImpl_2", "ebg-aqap-banks-jxnsb-cmp"),e);
            }
        } else {
            log.info("本次交易明细查询返回'报文'");
            content = body.getChildTextTrim(Constants.XML_serial_record);
        }
       // log.info("本次交易明细查询返回明细内容：" + content);
        String[][] r2 = parseRecord(content, recordNum, fieldNum);

        DetailInfo detailInfo;
        Map<String,Integer> countMap = Maps.newHashMapWithExpectedSize(1);
        for (int k = 0; k < r2.length; k++) {
            String[] r2_k = r2[k];
            detailInfo = parseR2(r2_k, rqst,countMap);
            details.add(detailInfo);
        }
        log.info("===解析<交易明细>报文结束===");
        return new EBBankDetailResponse(details);
    }

    private DetailInfo parseR2(String[] r2_k, BankDetailRequest req, Map<String,Integer> countMap){
        String serialNo =  r2_k[0];
        String acno = r2_k[1];// 账号
        String tr_currency = r2_k[2];// 货币码
        String tr_acdt = r2_k[3];// 交易日期
        String tr_time = r2_k[4];// 交易时间
        String host_serial_no = r2_k[5];// 主机流水号

        String acname = r2_k[7];// 户名

        String opp_acno = r2_k[8]; // 对方账号
        String opp_acname = r2_k[10]; // 对方账号户名
        String oppBank = r2_k[11]; // 对方账号开户行
        // String oppBankno = r2_k[12]; //对方行号
        // String tr_type = r2_k[13]; //交易类别
        // String area_flag = r2_k[16]; //同城异地标志
//		String crdr_flag = r2_k[23]; // 借贷标志
//		String amt = r2_k[24]; // 交易金额
        String balance = r2_k[25]; // 余额
        // 接口文档中摘要和附言与真实报文中的位置互换了
        String summary = r2_k[34]; // 附言(文档中此处是摘要)
        String summary2 = r2_k[35]; // 摘要(文档中此处是附言)
        String rcvamt = r2_k[44]; // 借入金额
        String payamt = r2_k[43]; // 借出金额

        DetailInfo detailInfo = new DetailInfo();
        // 本方账户
        detailInfo.setAccNo(acno);
        detailInfo.setAccName(acname);
        detailInfo.setBankName(req.getAcnt().getBankName());

        detailInfo.setOppAccNo(opp_acno);
        detailInfo.setOppAccName(opp_acname);
        detailInfo.setOppBankName(oppBank);

        detailInfo.setCurrency(tr_currency);

        // 交易日期
        detailInfo.setTransDate(LocalDate.parse(tr_acdt, DateTimeFormatter.ofPattern(Constants.Format_reqDate)));
        if (StringUtils.isEmpty(tr_time)){
            tr_time="000000";
        }
        detailInfo.setTransTime(LocalDateTime.parse(tr_acdt + tr_time, DateTimeFormatter.ofPattern(Constants.Format_reqDateTime)));
        // 借贷标志
        if (!StringUtils.isEmpty(payamt)) {
            detailInfo.setDebitAmount(new BigDecimal(payamt));
        }
        if (!StringUtils.isEmpty(rcvamt)) {
            detailInfo.setCreditAmount(new BigDecimal(rcvamt));
        }

        // 交易摘要
        detailInfo.setExplanation(summary);

        // 账户余额
        if (StringUtils.isNotEmpty(balance)) {
            detailInfo.setBalance(new BigDecimal(balance));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tr_acdt", tr_acdt);
        jsonObject.put("rcvamt", rcvamt);
        jsonObject.put("payamt", payamt);
        jsonObject.put("host_serial_no", host_serial_no);
        jsonObject.put("serial_no",serialNo);

        String crdr_flag = r2_k[23]; // 借贷标志
        String amt = r2_k[24]; // 交易金额
        jsonObject.put("amt",amt);
        jsonObject.put("crdr_flag",crdr_flag);
        detailInfo.setJsonMap(jsonObject.toString());
        packReceiptNo(countMap,detailInfo,req.getAcnt().getAccNo(),jsonObject.toJSONString());

        detailInfo.setBankDetailNo(host_serial_no);
        return detailInfo;
    }

    public void packReceiptNo(Map<String,Integer> countMap,DetailInfo detailInfo,String accNo,String json){
        String transDate = LocalDateUtil.formatDate(detailInfo.getTransDate());
        String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate,json );
        // 回单码防重复计数
        if(countMap.containsKey(receiptNo)){
            int count = countMap.get(receiptNo) + 1;
            countMap.put(receiptNo,count);
            receiptNo += "-" + String.format("%04d",count);
        }else{
            countMap.put(receiptNo,0);
        }
        detailInfo.setReceiptNo(receiptNo);
    }

    private String[][] parseRecord(String serial_record, int recordNum, int fieldNum) {
        String[] allrecord = StringUtils.split(serial_record, Constants.separator);
        String[][] r2 = new String[recordNum][fieldNum];
        for (int i = 0; i < recordNum; i++) {
            for (int j = 0; j < fieldNum; j++) {
                r2[i][j] = allrecord[(i + 1) * fieldNum + j];// 前42个全是字段名
            }
        }
        return r2;
    }

    @Override
    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg(super.recv(inputStream));
    }

}
