package kd.ebg.aqap.banks.jxnsb.cmp.services.payment;

import kd.ebg.aqap.banks.jxnsb.cmp.services.payment.Salary.SalaryPaymentImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.atomic.PretreatmentTrace;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class PretreatmentImpl extends PretreatmentTrace implements IPretreat {
    @Override
    public void appendData(PaymentInfo paymentInfo) {
        getBusiImplInfo(paymentInfo);
        setPayRouteTrace(paymentInfo);
    }

    @Override
    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        if(isPay(paymentInfo)){
            setImplClassName(paymentInfo, PaymentImpl.class.getName());
        }else if(isPay_for_salary(paymentInfo)){
            setImplClassName(paymentInfo, SalaryPaymentImpl.class.getName());
        }else if(isPay_for_capital_allocation(paymentInfo) && !isSameBank(paymentInfo)){
            setImplClassName(paymentInfo, PaymentImpl.class.getName());
        }else{
            throw EBExceiptionUtil.serviceException(ShowTipUtil.getSubBizTypeCheckMsg(paymentInfo.getSubBizType()));
        }
        return busiImplInfo;
    }

    @Override
    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        return null;
    }

    @Override
    public String getDeveloper() {
        return "";
    }

    @Override
    public String getBizCode() {
        return "";
    }

    @Override
    public String getBizDesc() {
        return "";
    }

    @Override
    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }
}
