package kd.ebg.aqap.banks.jxnsb.cmp.services.payment;
import kd.bos.dataentity.resource.ResManager;

import kd.ebg.aqap.banks.jxnsb.cmp.services.Common;
import kd.ebg.aqap.banks.jxnsb.cmp.services.Constants;
import kd.ebg.aqap.banks.jxnsb.cmp.services.Packer;
import kd.ebg.aqap.banks.jxnsb.cmp.services.utils.EncodeAnDecodeHandler;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import org.jdom2.Element;

import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class QryPaymentImpl extends AbstractQueryPayImpl implements IQueryPay {
    @Override
    public int getBatchSize() {
        return 0;
    }

    @Override
    public String pack(BankPayRequest bankPayRequest) {
        List<PaymentInfo> paymentInfos = bankPayRequest.getPaymentInfos();
                PaymentInfo paymentInfo = paymentInfos.get(0);
        String tr_code = Constants.CODE_PaymentState;
        String req_no = Sequence.genSequence();
        Element ap = Packer.createCommonHead(tr_code, req_no,"0"); // 报文头
        Element body = ap.getChild(Constants.XML_body);

        JDomUtils.addChild(body, "cert_no", paymentInfo.getPackageId()); // 凭证号
        JDomUtils.addChild(body, "req_no",paymentInfo.getPackageId()); // 请求号

        String d = paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild(body, "tr_acdt", d); // 交易日期

        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration(ap, encoding);
        xmlMsg = EncodeAnDecodeHandler.encode(xmlMsg);
        return Common.createCommonMsg(xmlMsg);
    }

    @Override
    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        s = EncodeAnDecodeHandler.decode(s);
        List<PaymentInfo> infos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root(s, encoding);

        Element head = ap.getChild(Constants.XML_head);
        BankResponse response = Common.parseBankResponse(head);

        if (!"0_0000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(infos, PaymentState.UNKNOWN, ResManager.loadKDString("交易结果未知", "QryPaymentImpl_0", "ebg-aqap-banks-jxnsb-cmp"), response.getResponseCode(), response.getResponseMessage());
            return new EBBankPayResponse(infos);
        }

        Element body = ap.getChild(Constants.XML_body);
        String stat = body.getChildTextTrim("stat");// 流水状态
        String cert_no = body.getChildTextTrim("cert_no");// 凭证号
        String req_no = body.getChildTextTrim("req_no");// 请求号
        String serial_no = body.getChildTextTrim("serial_no");// 现金管理平台流水号

        if ("9".equals(stat)) {
            EBGBusinessUtils.setPaymentState(infos, PaymentState.SUCCESS, ResManager.loadKDString("交易成功", "QryPaymentImpl_1", "ebg-aqap-banks-jxnsb-cmp"), stat, ResManager.loadKDString("交易成功", "QryPaymentImpl_1", "ebg-aqap-banks-jxnsb-cmp"));
        } else if ("6".equals(stat)) {
            EBGBusinessUtils.setPaymentState(infos, PaymentState.FAIL, ResManager.loadKDString("交易失败", "QryPaymentImpl_2", "ebg-aqap-banks-jxnsb-cmp"), stat, ResManager.loadKDString("交易失败", "QryPaymentImpl_2", "ebg-aqap-banks-jxnsb-cmp"));
        }else if ("3".equals(stat)) {
            EBGBusinessUtils.setPaymentState(infos, PaymentState.SUBMITED, ResManager.loadKDString("银行处理中", "QryPaymentImpl_3", "ebg-aqap-banks-jxnsb-cmp"), stat, ResManager.loadKDString("银行处理中", "QryPaymentImpl_3", "ebg-aqap-banks-jxnsb-cmp"));
        }else{
            EBGBusinessUtils.setPaymentState(infos, PaymentState.UNKNOWN, ResManager.loadKDString("交易结果未知", "QryPaymentImpl_0", "ebg-aqap-banks-jxnsb-cmp"), stat, ResManager.loadKDString("交易结果未知", "QryPaymentImpl_0", "ebg-aqap-banks-jxnsb-cmp"));
        }
        return new EBBankPayResponse(infos);
    }

    @Override
    public String getDeveloper() {
        return null;
    }

    @Override
    public String getBizCode() {
        return Constants.CODE_PaymentState;
    }

    @Override
    public String getBizDesc() {
        return null;
    }

    @Override
    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg(super.recv(inputStream));
    }
}
