package kd.ebg.aqap.banks.jxnsb.cmp.services.payment.Salary;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jxnsb.cmp.services.Common;
import kd.ebg.aqap.banks.jxnsb.cmp.services.Constants;
import kd.ebg.aqap.banks.jxnsb.cmp.services.Packer;
import kd.ebg.aqap.banks.jxnsb.cmp.services.utils.EncodeAnDecodeHandler;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;

public class SalaryPaymentImpl extends AbstractPayImpl implements IPay {
    private final static EBGLogger log = EBGLogger.getInstance().getLogger(SalaryPaymentImpl.class);
    @Override
    public int getBatchSize() {
        return 1000;
    }

    @Override
    public Class<? extends IQueryPay> defaultQueryClass() {
        return QrySalPaymentImpl.class;
    }

    @Override
    public String pack(BankPayRequest bankPayRequest) {
        List<PaymentInfo> paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo;
        //先构造代发文件内容
        StringBuilder sb = new StringBuilder("acno|cur_code|acname|cardflag|amt|interbank|bank_no|bank_name|postscript|");
        BigDecimal totalAmt = new BigDecimal("0.00");
        BigDecimal amt;
        for (int i = 0; i < paymentInfos.size(); i++) {
            paymentInfo = paymentInfos.get(i);
            amt = paymentInfos.get(i).getAmount();
            totalAmt = totalAmt.add(amt);
			
			/*acno|cur_code|acname|cardflag|amt|interbank|bank_no|bank_name|postscript|
			注意：文件内容第一行是字段名行，第二行才是数据，可参考附件
			中文说明
			账号(C35)|币种(C2)|户名(C140)|卡折标志(C1)|金额(N15,2)|跨行C(1)|开户行行号C(35)|开户行行名C(70)|附言(C300)|
			 */
            sb.append("\r\n");//换行符
            sb.append(paymentInfo.getIncomeAccNo()).append(Constants.separator);
            sb.append(paymentInfo.getCurrency()).append(Constants.separator);
            sb.append(paymentInfo.getIncomeAccName()).append(Constants.separator);
            sb.append("").append(Constants.separator);
            sb.append(amt.toPlainString()).append(Constants.separator);
            sb.append(paymentInfo.is2SameBank() ? "0" : "1").append(Constants.separator);
            sb.append(paymentInfo.getIncomeCnaps()).append(Constants.separator);
            sb.append(paymentInfo.getIncomeBankName()).append(Constants.separator);
            sb.append(paymentInfo.getExplanation()).append(Constants.separator);
        }

        String tr_code = Constants.CODE_Salary;
        Element ap = Packer.createCommonHead(tr_code, paymentInfos.get(0).getPackageId(), "1"); // 报文头
        Element body = ap.getChild(Constants.XML_body);

        JDomUtils.addChild(body, "pay_acno", paymentInfos.get(0).getAccNo()); // 付款账号
        JDomUtils.addChild(body, "pay_cur_code", paymentInfos.get(0).getCurrency());//付款币种
        JDomUtils.addChild(body, "pay_acname", paymentInfos.get(0).getAccName());//付款户名
        JDomUtils.addChild(body, "pay_accaddr", "");//付款人地址

        JDomUtils.addChild(body, "as_flag", "0");//是否使用账簿号  0：不需要 1：需要
        JDomUtils.addChild(body, "as_acno", "");//账簿号
        JDomUtils.addChild(body, "as_acname", "");//账簿名称
        JDomUtils.addChild(body, "vir_acno", "");//虚账号
        JDomUtils.addChild(body, "vir_acname", "");//虚账号名称
        JDomUtils.addChild(body, "supply_item", "341");//341-代发工资  379-其他代发
        JDomUtils.addChild(body, "batch_no", paymentInfos.get(0).getPackageId()); // 批次号
        JDomUtils.addChild(body, "count", "" + paymentInfos.size());//总笔数
        JDomUtils.addChild(body, "amt", totalAmt.toPlainString());//总交易金额
        JDomUtils.addChild(body, "purpose",paymentInfos.get(0).getExplanation());//用途
        JDomUtils.addChild(body, "postscript", paymentInfos.get(0).getExplanation());//附言
        JDomUtils.addChild(body, "qry_auth", "");
        String fileName = paymentInfos.get(0).getPackageId() + ".txt";
        JDomUtils.addChild(body, "file_name", fileName);//文件名
        JDomUtils.addChild(body, "field_num", "9");//文件域数
        JDomUtils.addChild(body, "record_num", paymentInfos.size() + "");//文件记录数
        JDomUtils.addChild(body, "CAPTCHA", "");//验证码

        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration(ap, encoding);
        log.info("---代发文件内容:" ,sb.toString());

        /*
         * upload sb代发文件
         * 2015.6.17 改指令上传为 远程目录上传
         */
//        try {
//            FileUtil fileUtil = new FileUtil();
//            fileUtil.uploadFile(fileName, sb.toString());
//        } catch (Exception e) {
//            throw BankServiceExceptionConverter.convert(e, "###[代发工资]上传文件失败");
//        }
        xmlMsg = EncodeAnDecodeHandler.encode(xmlMsg);
        return Common.createCommonMsg(xmlMsg);
    }

    @Override
    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        s = EncodeAnDecodeHandler.decode(s);
        List<PaymentInfo> paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root(s, encoding);

        Element head = ap.getChild(Constants.XML_head);
        BankResponse response = Common.parseBankResponse(head);
        String serialNo="";
        try {
            serialNo = head.getChildTextTrim("serial_no");
        } catch (Exception e) {
            log.info("获取serial_no异常"+e);
        }
        if(!StringUtils.isEmpty(serialNo)){
            PaymentInfoSysFiled.set(paymentInfos,Constants.JXNSBSERIALNO, serialNo);
        }

        if ("0_0000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(paymentInfos, PaymentState.SUBMITED, ResManager.loadKDString("银行处理中", "SalaryPaymentImpl_0", "ebg-aqap-banks-jxnsb-cmp"), response.getResponseCode(), response.getResponseMessage());
        }else{
            EBGBusinessUtils.setPaymentState(paymentInfos, PaymentState.UNKNOWN, ResManager.loadKDString("交易结果未知", "SalaryPaymentImpl_1", "ebg-aqap-banks-jxnsb-cmp"), response.getResponseCode(), response.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    @Override
    public String getDeveloper() {
        return null;
    }

    @Override
    public String getBizCode() {
        return null;
    }

    @Override
    public String getBizDesc() {
        return null;
    }

    @Override
    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType());
    }

    @Override
    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg(super.recv(inputStream));
    }
}
