package kd.ebg.aqap.banks.jxnsb.cmp.services.utils;

import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

import java.io.*;

/**
 * @Description
 * @Author yChiu
 * @Date 2024年09月09日 15:02
 */
public class FileHandler {

    /**
     * 重启容器后上传的文件会没有
     * 需要这里判断重新上传一遍
     * @return
     */
    public static String copyPublicFile() {

        EBGLogger logger = EBGLogger.getInstance().getLogger(FileHandler.class);
        String defaultPublicKeyPath = getPublicKeyPath();
        if (new File(defaultPublicKeyPath).exists()) {
            logger.info("路径{}下文件已经存在",defaultPublicKeyPath);
            return defaultPublicKeyPath;
        }
        String content = getSecretKey();
        try (FileWriter writer = new FileWriter(defaultPublicKeyPath)) {
            writer.write(content);
        } catch (IOException e) {
            logger.info("写入文件异常" + e.getMessage());
            e.printStackTrace();
        }

        return defaultPublicKeyPath;
    }


    public static String getSecretKey() {
        // 0C79CE66924D70B98211D9BF9F563A17
        String key = RequestContextUtils.getCustomId() + "_JXNSB_secretKey";
        String secretKey = CosmicCache.get(key);
        if (StringUtils.isEmpty(secretKey)) {
            UserCertRepository userCertRepository = SpringContextUtil.getBean(UserCertRepository.class);
            CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID("secretKey", RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getCustomId());
            AESCipherSecurity security = SpringContextUtil.getBean(AESCipherSecurity.class);
            CipherInfo cipherInfo = security.getCipherInfo(certInfo.getFileContent());
            int version = cipherInfo.getCipherVersion();
            byte[] certBytes = org.apache.commons.codec.binary.Base64.decodeBase64(cipherInfo.getCipherData());
            byte[] plainData = DesUtil.decryptProxyCert(certBytes, RequestContextUtils.getCustomId(), version, "");
            secretKey = StringUtils.byteToString(plainData);
            CosmicCache.putIfAbsent(key, secretKey);
        }

        return secretKey;
    }

    public static String getPublicKeyPath() {
        String defaultPublicKeyPath = "/mservice/lib/biz/PUBLICKEY.txt";
//        boolean isWindows = System.getProperty("os.name").contains("Windows");
//        if (isWindows) {
//            defaultPublicKeyPath = "C:\\biz-evn-dev\\mservice\\lib\\biz\\PUBLICKEY.txt";
//        }
        return defaultPublicKeyPath;
    }

}
