/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.cache;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.ebg.egf.common.framework.app.AppEnum;
import kd.ebg.egf.common.utils.string.StringUtils;

public class AppMenuCache {
    private Map<String, AppMenuInfo> FormIDToMenuMap = new HashMap<String, AppMenuInfo>(1);
    private Map<String, AppMenuInfo> AppMenuMap = new HashMap<String, AppMenuInfo>(1);

    public AppMenuCache() {
        this.reload();
    }

    private void reload() {
        ArrayList appList = Lists.newArrayList((Object[])new String[]{AppEnum.AQAP.getId(), AppEnum.RECEIPT.getId(), AppEnum.NOTE.getId()});
        for (String appId : appList) {
            List appMenuInfoList = AppMetadataCache.getAppMenusInfoByAppId((String)appId);
            for (AppMenuInfo menuInfo : appMenuInfoList) {
                String id;
                String formId = menuInfo.getFormId();
                if (StringUtils.isNotEmpty(formId)) {
                    this.FormIDToMenuMap.put(formId, menuInfo);
                }
                if (!StringUtils.isNotEmpty(id = menuInfo.getId())) continue;
                this.AppMenuMap.put(id, menuInfo);
            }
        }
    }

    public String getMenuPath(String formID) {
        String menuID = "";
        String appID = "";
        if (this.FormIDToMenuMap.containsKey(formID)) {
            AppMenuInfo menuInfo = this.FormIDToMenuMap.get(formID);
            menuID = menuInfo.getId();
            appID = menuInfo.getAppId();
        }
        boolean flag = StringUtils.isNotEmpty(menuID);
        ArrayList<String> nodes = new ArrayList<String>(1);
        while (flag) {
            AppMenuInfo menuInfo = this.AppMenuMap.get(menuID);
            nodes.add(menuInfo.getName().getLocaleValue());
            menuID = menuInfo.getParentId();
            flag = StringUtils.isNotEmpty(menuInfo.getFormId());
        }
        StringBuilder sb = new StringBuilder();
        for (int i = nodes.size() - 1; i >= 0; --i) {
            sb.append((String)nodes.get(i));
            if (i <= 0) continue;
            sb.append('/');
        }
        String menuPath = sb.toString();
        if (StringUtils.isNotEmpty(menuPath) && StringUtils.isNotEmpty(appID)) {
            String appName = AppMetadataCache.getAppInfo((String)appID).getName().getLocaleValue();
            menuPath = appName + ":" + menuPath;
        }
        return menuPath;
    }
}

