/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.cache;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BankVersionCache {
    private static BankVersionCache instance = new BankVersionCache();
    private Map<String, DynamicObject> cacheMap = new HashMap<String, DynamicObject>(16);

    public static BankVersionCache getInstance() {
        return instance;
    }

    public BankVersionCache() {
        this.initCache();
    }

    public String getBankName(String bankVersionID) {
        String bankName = bankVersionID;
        if (StringUtils.isNotEmpty(bankVersionID) && this.cacheMap.containsKey(bankVersionID)) {
            DynamicObject dynamicObject = this.cacheMap.get(bankVersionID);
            bankName = dynamicObject.getString("bank_name");
        }
        return bankName;
    }

    public String getBankVersionName(String bankVersionID) {
        String bankName = bankVersionID;
        if (StringUtils.isNotEmpty(bankVersionID) && this.cacheMap.containsKey(bankVersionID)) {
            DynamicObject dynamicObject = this.cacheMap.get(bankVersionID);
            bankName = dynamicObject.getString("name");
        }
        return bankName;
    }

    private void initCache() {
        DynamicObject[] dynamicObjects;
        for (DynamicObject dynamicObject : dynamicObjects = BankVersionRepository.getInstance().loadDynamicObjects()) {
            String id = dynamicObject.getString("number");
            this.cacheMap.put(id, dynamicObject);
        }
    }
}

