/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.codeless.PackerUtil;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.UUID;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;

public class DataUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DataUtil.class);

    public static String getValue(String paramName) {
        if ("util_yyyyMMdd".equals(paramName)) {
            return LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        }
        if ("util_yyyy-MM-dd HH:mm:ss".equals(paramName)) {
            return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        if ("util_16sequence".equals(paramName)) {
            return Sequence.gen16NumSequence() + "";
        }
        if ("util_16sequencemax".equals(paramName)) {
            return Sequence.gen16Sequence();
        }
        if ("util_HHmmss".equals(paramName)) {
            Date now = new Date();
            return new SimpleDateFormat("HHmmss").format(now);
        }
        if ("util_UUID".equals(paramName)) {
            return UUID.randomUUID().toString().replace("-", "");
        }
        if ("util_YYYYMMDDhhmmss".equals(paramName)) {
            return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        }
        if ("util_MAC".equals(paramName)) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
                byte[] mac = networkInterface.getHardwareAddress();
                StringBuilder macAddress = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    macAddress.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                }
                return macAddress.toString();
            }
            catch (Exception e) {
                logger.error("mac address error ", e);
                return "";
            }
        }
        if ("util_yyyy-MM-dd".equalsIgnoreCase(paramName)) {
            return LocalDate.now().format(DateTimeFormatter.ISO_DATE);
        }
        return "";
    }
}

