/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.codeless.PackerUtil;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.HttpConnection;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class FroxyImpl
extends AbstractImpl {
    public String uploadFile(String bizSeqId, String fileName, String Content2, String type) {
        String rqstStr = this.packUplaodFileXML(fileName, Content2, type);
        String rspStr = this.sendAndRecvMsg(rqstStr);
        return this.parseUplaodFileXML(rspStr);
    }

    public static String getMD5(String s, String encoding) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty(s)) {
            return null;
        }
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (md5 != null) {
            md5.update(s.getBytes(encoding));
        }
        StringBuilder sb = new StringBuilder();
        if (md5 != null) {
            for (byte b : md5.digest()) {
                sb.append(String.format("%02X", b));
            }
        }
        return sb.toString().toLowerCase(Locale.ENGLISH);
    }

    public String packUplaodFileXML(String fileName, String Content2, String type) {
        Element simulator = JDomUtils.createRoot("simulator");
        Element head = FroxyImpl.createHead(type);
        JDomUtils.addChild(simulator, head);
        Element body = JDomUtils.addChild(simulator, "body");
        Element reqPara = JDomUtils.addChild(body, "reqPara");
        JDomUtils.addChild(reqPara, "bankMsg", "");
        JDomUtils.addChild(reqPara, "file", fileName);
        JDomUtils.addChild(reqPara, "fileContent", Content2);
        return JDomUtils.root2String(simulator, "UTF-8");
    }

    public static Element createHead(String bizType) {
        return FroxyImpl.createHead(bizType, Sequence.genSequence());
    }

    public static Element createHead(String bizType, String seqno) {
        Element head = new Element("head");
        JDomUtils.addChild(head, "sequence", seqno);
        JDomUtils.addChild(head, "bizType", bizType);
        TimeZone china = TimeZone.getTimeZone("GMT+:08:00");
        JDomUtils.addChild(head, "reqDate", DateTimeUtils.formatDate(new Date(), china));
        JDomUtils.addChild(head, "reqTime", DateTimeUtils.formatTime(new Date(), china));
        return head;
    }

    public String sendAndRecvMsg(String rqstStr, String bizSeqId) {
        String rspStr = "";
        try {
            ConnectionFactory connectionFactory = this.getConnectionFactory();
            IConnection conn = this.getFrontProxyConnection(connectionFactory);
            this.openConnection(conn);
            try (OutputStream os = this.getOutputStream(conn);){
                this.send(os, rqstStr);
                try (InputStream is = this.getInputStream(conn);){
                    rspStr = this.recv(is);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException(e);
        }
        return rspStr;
    }

    private String parseUplaodFileXML(String rspStr) {
        Element root = JDomUtils.string2Root(rspStr, "UTF-8");
        BankResponse rsp = FroxyImpl.parseHeader(root);
        if (!"BIZ_SUCCESS".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38 ,%1$s,%2$s", (String)"CCB_DCFileUtil_9", (String)"ebg-egf-common", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = JDomUtils.getChildElementNotNull(root, "body");
        Element rspPara = JDomUtils.getChildElementNotNull(body, "rspPara");
        Element status = JDomUtils.getChildElementNotNull(rspPara, "status");
        String ReturnCode = JDomUtils.getChildTextTrimNotNull(status, "code", ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u7801", (String)"CCB_DCFileUtil_1", (String)"ebg-egf-common", (Object[])new Object[0]));
        String ReturnMsg = JDomUtils.getChildTextTrim(status, "msg");
        if (!"SUCCESS".equals(ReturnCode)) {
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25 ,%1$s,%2$s", (String)"CCB_DCFileUtil_8", (String)"ebg-egf-common", (Object[])new Object[0]), ReturnCode, ReturnMsg));
        }
        Element filContent = JDomUtils.getChildElementNotNull(rspPara, "fileContent");
        String fileName = filContent.getTextTrim();
        return fileName;
    }

    public static BankResponse parseHeader(Element root) {
        Element Head = JDomUtils.getChildElementNotNull(root, "head");
        String IBSReturnCode = JDomUtils.getChildTextNotNull(Head, "rspcode", ResManager.loadKDString((String)"\u54cd\u5e94\u7801", (String)"FroxyImpl_2", (String)"ebg-egf-common", (Object[])new Object[0]));
        String IBSReturnMsg = JDomUtils.getChildTextNullAsBlank(Head, "rspMsg");
        BankResponse response = new BankResponse();
        response.setResponseCode(IBSReturnCode);
        response.setResponseMessage(IBSReturnMsg);
        return response;
    }

    private String sendAndRecvMsg(String rqstStr) {
        String ip = RequestContextUtils.getBankParameterValue("ip");
        String portStr = RequestContextUtils.getBankParameterValue("frontProxy_port");
        String timeOutStr = RequestContextUtils.getBankParameterValue("timeout");
        int port = Integer.parseInt(portStr);
        int timeOut = Integer.parseInt(timeOutStr);
        HashMap<String, String> header = new HashMap<String, String>();
        HttpConnection conn = new HttpConnection(ip, port, "", header, timeOut);
        this.openConnection(conn);
        String rspStr = "";
        try (OutputStream os = this.getOutputStream(conn);){
            IOUtils.sendFully(os, rqstStr, "UTF-8");
            try (InputStream is = this.getInputStream(conn);){
                rspStr = IOUtils.readFully(is, "UTF-8");
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u7968\u636e\u4fe1\u606f\u4e1a\u52a1\u51fa\u73b0\u5f02\u5e38", (String)"CCB_DCFileUtil_6", (String)"ebg-egf-common", (Object[])new Object[0]), e);
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u7968\u636e\u4fe1\u606f\u4e1a\u52a1\u51fa\u73b0\u5f02\u5e38", (String)"CCB_DCFileUtil_6", (String)"ebg-egf-common", (Object[])new Object[0]), e);
        }
        return rspStr;
    }
}

