/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.codeless.PageUtil;

import java.util.List;
import kd.ebg.egf.common.codeless.ParserUtil.JSONParseUtil;
import kd.ebg.egf.common.codeless.ParserUtil.XMLParseUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.codeless.CodeLess;
import kd.ebg.egf.common.model.codeless.CodelessLastPageBody;
import kd.ebg.egf.common.model.codeless.CodelessNextPageBody;
import kd.ebg.egf.common.model.codeless.CodelessPageParam;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;

public class PageLogicUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(PageLogicUtil.class);
    private static final String SPLIT = " ";
    private static final String LEFT = "(";
    private static final String RIGHT = ")";
    private static final String PREFIX = "\"";

    public static String generateLogicStr(List<CodelessPageParam> bodyList, String response, String type, String pageTag) {
        StringBuilder content = new StringBuilder();
        boolean hasRightBracket = false;
        for (CodelessPageParam info : bodyList) {
            boolean isBracket;
            String paramType = info.getParamType();
            String value = "";
            value = "0".equals(paramType) ? PageLogicUtil.getOriginValue(type, response, info.getParamValue()) : ("pageTag".equals(info.getParamValue()) ? pageTag : info.getParamValue());
            String operator = info.getOperator();
            String Bracket = info.getBracket();
            boolean bl = isBracket = StringUtils.isNotEmpty(Bracket) && "1".equals(Bracket);
            if (hasRightBracket && isBracket) {
                content.insert(content.lastIndexOf(LEFT), LEFT);
            } else if (isBracket) {
                content.append(LEFT);
            }
            if (StringUtils.isNumeric(value)) {
                content.append(value);
            } else {
                content.append(PREFIX).append(value).append(PREFIX);
            }
            if (hasRightBracket) {
                content.append(RIGHT);
            }
            if (StringUtils.isNotEmpty(operator)) {
                content.append(SPLIT).append(operator).append(SPLIT);
            }
            hasRightBracket = isBracket;
        }
        return content.toString();
    }

    public static String getOriginValue(String type, String response, String rootPath) {
        if ("xml".equals(type)) {
            return XMLParseUtil.getXmlAttrValue(response, rootPath);
        }
        return JSONParseUtil.getJsonAttrValue(response, rootPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Boolean runLastPage(String jsStr) {
        try (Context context = Context.newBuilder((String[])new String[0]).allowAllAccess(true).build();){
            Value js = context.eval("js", (CharSequence)jsStr);
            Boolean bl = js.asBoolean();
            return bl;
        }
        catch (Exception e) {
            logger.error(EBExceiptionUtil.stackTraceString(e.getStackTrace()));
            logger.info("\u6700\u540e\u4e00\u9875\u903b\u8f91\u8fd0\u7b97\u9519\u8bef\uff0c\u8fd0\u7b97\u5185\u5bb9:{}", (Object)jsStr);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String runNextPage(String jsStr) {
        try (Context context = Context.newBuilder((String[])new String[0]).allowAllAccess(true).build();){
            Value js = context.eval("js", (CharSequence)jsStr);
            if (js.isNumber()) {
                String string2 = js.asInt() + "";
                return string2;
            }
            String string = js.asString();
            return string;
        }
        catch (Exception e) {
            logger.error(EBExceiptionUtil.stackTraceString(e.getStackTrace()));
            logger.info("\u4e0b\u4e00\u9875\u903b\u8f91\u8fd0\u7b97\u9519\u8bef\uff0c\u8fd0\u7b97\u5185\u5bb9:{}", (Object)jsStr);
            return null;
        }
    }

    public static boolean isLastPage(CodeLess codeless, String response, String pageTag) {
        List<CodelessLastPageBody> lastPageBodys = codeless.getLastPageBodys();
        for (CodelessLastPageBody lastPage : lastPageBodys) {
            String temp = PageLogicUtil.generateLogicStr(lastPage.getLastPageSchemes(), response, codeless.getContentType(), pageTag);
            Boolean tempResult = PageLogicUtil.runLastPage(temp);
            if (tempResult == null) {
                return true;
            }
            if (!tempResult.booleanValue()) continue;
            String result = lastPage.getResult();
            return "1".equals(result);
        }
        return true;
    }

    public static String getNextPage(CodeLess codeless, String response, String pageTag) {
        List<CodelessNextPageBody> nextPageBodys = codeless.getNextPageBodys();
        if (nextPageBodys.size() == 0) {
            return pageTag;
        }
        CodelessNextPageBody body = nextPageBodys.get(0);
        List<CodelessPageParam> pageParams = body.getPageParams();
        String temp = PageLogicUtil.generateLogicStr(pageParams, response, codeless.getContentType(), pageTag);
        String s = PageLogicUtil.runNextPage(temp);
        if (StringUtils.isEmpty(s)) {
            return "";
        }
        return s;
    }
}

