/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.codeless.ParserUtil;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;

public class JSONParseUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(JSONParseUtil.class);

    public static String getJsonAttrValue(String json, String attrName) {
        if (null == json || json.equals("") || null == attrName || attrName.equals("")) {
            logger.error("parser error :" + json + attrName);
            throw EBExceiptionUtil.serviceException("parser json error :" + json + attrName);
        }
        String[] attrs = attrName.split("\\.");
        int length = attrs.length;
        String result = null;
        JSONObject jsonObj = null;
        try {
            jsonObj = JSONObject.parseObject((String)json);
        }
        catch (Exception e) {
            logger.error("json parser error ", e.getMessage());
            throw EBExceiptionUtil.serviceException(e);
        }
        for (int i = 0; i < length; ++i) {
            Object value = jsonObj.get((Object)attrs[i]);
            if (i == length - 1) {
                if (value == null) {
                    result = null;
                    break;
                }
                result = (String)value;
                break;
            }
            if (value instanceof JSONObject) {
                jsonObj = (JSONObject)value;
                continue;
            }
            if (value instanceof JSONArray) {
                JSONArray array = (JSONArray)value;
                jsonObj = array.getJSONObject(0);
                continue;
            }
            throw EBExceiptionUtil.serviceException("json struct error");
        }
        return result;
    }
}

