/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.codeless.dateUtil;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.egf.common.codeless.dateUtil.LocalDateUtil;

public class LocalDateTimeUtil {
    private static final List<DateTimeFormatter> DATETIME_FORMATTERS = new ArrayList<DateTimeFormatter>();

    public static LocalDateTime tryParse(String dateTimeString) {
        for (DateTimeFormatter formatter : DATETIME_FORMATTERS) {
            try {
                return LocalDateTime.parse(dateTimeString, formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        LocalDate date = LocalDateUtil.tryParse(dateTimeString);
        if (date != null) {
            return LocalDateTime.of(date, LocalTime.MIDNIGHT);
        }
        return null;
    }

    public static void main(String[] args) {
        String dateString = "2024-02-04";
        String dateTimeString = "2024-02-0415:30:45";
        LocalDateTime dateTime1 = LocalDateTimeUtil.tryParse(dateString);
        LocalDateTime dateTime2 = LocalDateTimeUtil.tryParse(dateTimeString);
        System.out.println(dateTime1);
        System.out.println(dateTime2);
    }

    static {
        DATETIME_FORMATTERS.add(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        DATETIME_FORMATTERS.add(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        DATETIME_FORMATTERS.add(DateTimeFormatter.ofPattern("yyyy-MM-ddHH:mm:ss"));
        DATETIME_FORMATTERS.add(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
        DATETIME_FORMATTERS.add(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssX"));
    }
}

