/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.codeless.dateUtil;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;

public class LocalDateUtil {
    private static final List<DateTimeFormatter> FORMATTERS = new ArrayList<DateTimeFormatter>();

    public static LocalDate tryParse(String dateString) {
        for (DateTimeFormatter formatter : FORMATTERS) {
            try {
                return LocalDate.parse(dateString, formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }

    public static void main(String[] args) {
        String dateString1 = "20240204";
        String dateString2 = "2024-02-04";
        LocalDate date1 = LocalDateUtil.tryParse(dateString1);
        LocalDate date2 = LocalDateUtil.tryParse(dateString2);
        System.out.println(date1);
        System.out.println(date2);
    }

    static {
        FORMATTERS.add(DateTimeFormatter.ofPattern("yyyyMMdd"));
        FORMATTERS.add(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        FORMATTERS.add(DateTimeFormatter.ofPattern("dd-MM-yyyy"));
    }
}

