/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.context;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.cache.CosmicConstants;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.context.BaseContext;
import kd.ebg.egf.common.framework.conf.ParameterImpl;
import kd.ebg.egf.common.framework.service.BankLoginConfigService;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;
import kd.ebg.egf.common.model.bank.login.ProxyBankLogin;
import kd.ebg.egf.common.model.codeless.CodeLess;
import kd.ebg.egf.common.model.proxy.BankLoginProxyConfig;
import kd.ebg.egf.common.repository.bank.config.BankLoginProxyConfigRepository;
import kd.ebg.egf.common.repository.bank.login.ProxyBankLoginRepository;
import kd.ebg.egf.common.utils.AESUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.annotation.SdkDeprecated;

public class EBContext
extends BaseContext {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(EBContext.class);
    private static ThreadLocal<EBContext> contextThreadLocal = new ThreadLocal();
    private Object result;
    private Object reDevResult;

    @SdkDeprecated
    public static EBContext getContext() {
        Preconditions.checkNotNull(contextThreadLocal, (Object)ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u4e0a\u4e0b\u6587\u5bf9\u8c61\u5f15\u7528\u4e0d\u5b58\u5728\u3002", (String)"EBContext_0", (String)"ebg-egf-common", (Object[])new Object[0]));
        return contextThreadLocal.get();
    }

    public static void setContext(EBContext context) {
        Preconditions.checkNotNull((Object)context, (Object)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u4e1a\u52a1\u4e0a\u4e0b\u6587\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"EBContext_1", (String)"ebg-egf-common", (Object[])new Object[0]));
        Preconditions.checkNotNull(contextThreadLocal, (Object)ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u4e0a\u4e0b\u6587\u5bf9\u8c61\u5f15\u7528\u4e0d\u5b58\u5728\u3002", (String)"EBContext_0", (String)"ebg-egf-common", (Object[])new Object[0]));
        contextThreadLocal.set(context);
    }

    public static void destroy() {
        contextThreadLocal.remove();
    }

    public static void initParameter(String bankVersionID, String bankLoginID) {
        EBContext context = contextThreadLocal.get();
        context.setBankVersionID(bankVersionID);
        context.setBankLoginID(bankLoginID);
        EBContext.initParameter();
    }

    static String getBusinessTypeByBizName(String bizName) {
        if ("pay".equals(bizName) || "queryPay".equals(bizName) || "linkpay".equals(bizName) || "queryLinkpay".equals(bizName) || "overseaPay".equals(bizName) || "queryOverseaPay".equals(bizName) || "updatePayStatus".equals(bizName)) {
            return "pay";
        }
        if ("balance".equals(bizName) || "batchBalance".equals(bizName)) {
            return "query_balance";
        }
        if ("detail".equals(bizName) || "detailAsync".equals(bizName)) {
            return "query_detail";
        }
        if ("queryCredit".equals(bizName) || "openCredit".equals(bizName) || "openCreditQuery".equals(bizName) || "queryCreditReceived".equals(bizName)) {
            return "credit";
        }
        if ("notePayable".equals(bizName) || "queryNotePayable".equals(bizName) || "noteReceivable".equals(bizName) || "queryNoteReceivable".equals(bizName) || "queryNoteDetail".equals(bizName) || "queryNoteInfo".equals(bizName)) {
            return "note";
        }
        return "";
    }

    static String getBankLoginConfigTypeNameByBusinessType(String businessType) {
        if (StringUtils.isEmpty(businessType)) {
            return "";
        }
        switch (businessType) {
            case "pay": {
                return CosmicConstants.BANK_LOGIN_REL_CONFIG_TYPE_PAY;
            }
            case "query_balance": {
                return CosmicConstants.BANK_LOGIN_REL_CONFIG_TYPE_BALANCE;
            }
            case "query_detail": {
                return CosmicConstants.BANK_LOGIN_REL_CONFIG_TYPE_DETAIL;
            }
            case "credit": {
                return CosmicConstants.BANK_LOGIN_REL_CONFIG_TYPE_CREDIT;
            }
        }
        return "";
    }

    static String getBankLoginConfigTypeNameByBizName(String bizName) {
        return EBContext.getBankLoginConfigTypeNameByBusinessType(EBContext.getBusinessTypeByBizName(bizName));
    }

    public static void initParameter() {
        BankLoginProxyConfig proxyConfig;
        EBContext context = contextThreadLocal.get();
        Preconditions.checkNotNull((Object)context, (Object)ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u4e0a\u4e0b\u6587\u4e0d\u5b58\u5728\u3002", (String)"EBContext_2", (String)"ebg-egf-common", (Object[])new Object[0]));
        String bankVersionID = context.getBankVersionID();
        String bankLoginID = context.getBankLoginID();
        Preconditions.checkNotNull((Object)bankVersionID, (Object)ResManager.loadKDString((String)"\u5f53\u524d\u4e0a\u4e0b\u6587\u4e2d\u672a\u8bbe\u7f6e bankVersionID\u3002", (String)"EBContext_3", (String)"ebg-egf-common", (Object[])new Object[0]));
        Preconditions.checkNotNull((Object)bankLoginID, (Object)ResManager.loadKDString((String)"\u5f53\u524d\u4e0a\u4e0b\u6587\u4e2d\u6ca1\u6709\u8bbe\u7f6e bankLoginID\u3002", (String)"EBContext_4", (String)"ebg-egf-common", (Object[])new Object[0]));
        String configType = EBContext.getBankLoginConfigTypeNameByBizName(context.getBizName());
        String businessBankLoginID = BankLoginConfigService.getInstance().getBankLoginRelPayExclusiveNumberAndConfigType(bankLoginID, configType);
        if (StringUtils.isNotEmpty(businessBankLoginID)) {
            logger.info(bankLoginID + "\u7684" + configType + "\u7c7b\u578b\u63a5\u53e3\u8def\u7531\u5230" + businessBankLoginID + "\u6765\u53d1\u9001");
            bankLoginID = businessBankLoginID;
            context.setBankLoginID(bankLoginID);
        }
        ParameterImpl parameter = new ParameterImpl();
        List<BankLoginConfig> configs = BankLoginConfigService.getInstance().getBankLoginConfigByBankLogin(bankLoginID, context.getCustomID());
        if (Objects.nonNull(configs) && !configs.isEmpty()) {
            configs.forEach(config -> {
                String configID = config.getKey().getBankConfigId();
                String configValue = config.getBankConfigValue();
                String id = config.getId();
                if (StringUtils.isEmpty(config.getInputType())) {
                    configValue = AESUtil.unencryptedDesEncrypt(configValue, id);
                } else if (ConfigInputType.PASSWORD.getInputType().equalsIgnoreCase(config.getInputType())) {
                    configValue = AESUtil.unencryptedDesEncrypt(configValue, id);
                }
                parameter.setBankParameter(configID, configValue);
            });
        }
        if ((proxyConfig = BankLoginProxyConfigRepository.getInstance().findById(context.getCustomID())) != null) {
            if ("bankLoginProxy_test".equalsIgnoreCase(context.getBankVersionID())) {
                context.setProxyType(2);
                context.setProxyConfig(proxyConfig);
            } else {
                List<ProxyBankLogin> proxyLogins = ProxyBankLoginRepository.getInstance().findByKey_CustomId(context.getCustomID());
                if (proxyLogins != null && proxyLogins.size() > 0) {
                    for (ProxyBankLogin login : proxyLogins) {
                        if (!bankLoginID.equalsIgnoreCase(login.getBankLoginId())) continue;
                        context.setProxyType(2);
                        context.setProxyConfig(proxyConfig);
                        break;
                    }
                }
            }
        }
        if (context.getAcnt() != null) {
            BankAcnt acnt = context.getAcnt();
            DynamicObject[] dynamicObjects = BankAcntService.getInstance().getAccnoProperty(acnt.getAccNo());
            if (dynamicObjects != null) {
                for (DynamicObject object : dynamicObjects) {
                    String key = (String)object.get("attr_key");
                    String value = (String)object.get("attr_value");
                    if (StringUtils.isEmpty(value)) {
                        value = "";
                    }
                    parameter.setBankParameter("accno_" + key, value);
                }
            }
        }
        context.setParameter(parameter);
        if (StringUtils.isEmpty(parameter.getBankParameter("charset"))) {
            context.setCharsetName("UTF-8");
        } else {
            context.setCharsetName(parameter.getBankParameter("charset"));
        }
    }

    public static ThreadLocal<EBContext> getContextThreadLocal() {
        return contextThreadLocal;
    }

    public static void setContextThreadLocal(ThreadLocal<EBContext> contextThreadLocal) {
        EBContext.contextThreadLocal = contextThreadLocal;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Object getReDevResult() {
        return this.reDevResult;
    }

    public void setReDevResult(Object reDevResult) {
        this.reDevResult = reDevResult;
    }

    public static class Builder {
        String customID;
        String bankVersionID;
        String bankLoginID;
        String requestSeqID;
        String bizSeqID;
        long createTime;
        String bizName;
        String subBizName;
        String logRequestSeqID;
        String logBizSeqID;
        String businessType;
        String logger_batch_no;
        String logger_bank_no;
        String logger_detail_no;
        boolean schedule;
        boolean isRemoveWriteResponseLog;
        private CodeLess codeLess;
        String logger_sub_type;

        public Builder loggerSubType(String loggerSubType) {
            this.logger_sub_type = loggerSubType;
            return this;
        }

        public Builder codeLess(CodeLess codeLess) {
            this.codeLess = codeLess;
            return this;
        }

        public Builder schedule(boolean schedule) {
            this.schedule = schedule;
            return this;
        }

        public Builder loggerBatchNo(String logger_batch_no) {
            this.logger_batch_no = logger_batch_no;
            return this;
        }

        public Builder loggerBankNo(String logger_bank_no) {
            this.logger_bank_no = logger_bank_no;
            return this;
        }

        public Builder loggerDetailNo(String logger_detail_no) {
            this.logger_detail_no = logger_detail_no;
            return this;
        }

        public Builder customID(String customID) {
            this.customID = customID;
            return this;
        }

        public Builder bankVersionID(String bankVersionID) {
            this.bankVersionID = bankVersionID;
            return this;
        }

        public Builder bankLoginID(String bankLoginID) {
            this.bankLoginID = bankLoginID;
            return this;
        }

        public Builder requestSeqID(String requestSeqID) {
            this.requestSeqID = requestSeqID;
            return this;
        }

        public Builder bizSeqID(String bizSeqID) {
            this.bizSeqID = bizSeqID;
            return this;
        }

        public Builder createTime(long createTime) {
            this.createTime = createTime;
            return this;
        }

        public Builder bizName(String bizName) {
            this.bizName = bizName;
            return this;
        }

        public Builder subBizName(String subBizName) {
            this.subBizName = subBizName;
            return this;
        }

        public Builder logRequestSeqID(String logRequestSeqID) {
            this.logRequestSeqID = logRequestSeqID;
            return this;
        }

        public Builder logBizSeqID(String logBizSeqID) {
            this.logBizSeqID = logBizSeqID;
            return this;
        }

        public Builder businessType(String businessType) {
            this.businessType = businessType;
            return this;
        }

        public Builder isRemoveWriteResponseLog(boolean isRemoveWriteResponseLog) {
            this.isRemoveWriteResponseLog = isRemoveWriteResponseLog;
            return this;
        }

        public EBContext build() {
            EBContext ebContext = new EBContext();
            ebContext.setCustomID(this.customID);
            ebContext.setBankLoginID(this.bankLoginID);
            ebContext.setBankVersionID(this.bankVersionID);
            ebContext.setRequestSeqID(this.requestSeqID);
            ebContext.setBizSeqID(this.bizSeqID);
            ebContext.setCreateTime(this.createTime);
            ebContext.setBizName(this.bizName);
            ebContext.setSubBizName(this.subBizName);
            ebContext.setLogRequestSeqID(this.logRequestSeqID);
            ebContext.setLogBizSeqID(this.logBizSeqID);
            ebContext.setBusinessType(this.businessType);
            ebContext.setLogger_batch_no(this.logger_batch_no);
            ebContext.setLogger_detail_no(this.logger_detail_no);
            ebContext.setLogger_bank_no(this.logger_bank_no);
            ebContext.setRemoveWriteResponseLog(this.isRemoveWriteResponseLog);
            ebContext.setCodeLess(this.codeLess);
            ebContext.setScheduleJob(this.schedule);
            ebContext.setLogger_sub_type(this.logger_sub_type);
            return ebContext;
        }
    }
}

