/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.exception;

import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBConnection;
import kd.ebg.egf.common.exception.EBDbSaveException;
import kd.ebg.egf.common.exception.EBDuplicateException;
import kd.ebg.egf.common.exception.EBLoginAccessException;
import kd.ebg.egf.common.exception.EBPayFailException;
import kd.ebg.egf.common.exception.EBPayUnknownException;
import kd.ebg.egf.common.exception.EBPreCheckException;
import kd.ebg.egf.common.exception.EBPreYERequestException;
import kd.ebg.egf.common.exception.EBRePayException;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.exception.EBYEFailException;
import kd.ebg.egf.common.framework.lang.MultiLang;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.annotation.SdkDeprecated;

public class EBExceiptionUtil {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(EBExceiptionUtil.class);

    @SdkDeprecated
    public static EBServiceException serviceException(String message) {
        return new EBServiceException(message);
    }

    @SdkDeprecated
    public static EBServiceException serviceException(String message, String errorCode) {
        EBServiceException ebServiceException = new EBServiceException(message);
        ebServiceException.setErrorCode(errorCode);
        return ebServiceException;
    }

    @SdkDeprecated
    public static EBServiceException serviceException(Throwable t) {
        String errorMsg = MultiLang.getExceptionTip(t.getMessage());
        if (StringUtils.isNotEmpty(t.getMessage())) {
            logger.error(errorMsg, t);
        }
        return new EBServiceException(errorMsg, t);
    }

    @SdkDeprecated
    public static EBServiceException serviceException(String message, Throwable t) {
        logger.error(message, t);
        return new EBServiceException(message, t);
    }

    @SdkDeprecated
    public static EBServiceException serviceException(String message, String errorCode, Throwable t) {
        logger.error(message, t);
        EBServiceException ebServiceException = new EBServiceException(message, t);
        if (StringUtils.isNotEmpty(errorCode)) {
            ebServiceException.setErrorCode(errorCode);
        }
        return ebServiceException;
    }

    public static EBPreCheckException preCheckException(String message) {
        return new EBPreCheckException(message);
    }

    public static EBPreCheckException preCheckException(String errorCode, String message) {
        return new EBPreCheckException(errorCode, message);
    }

    public static EBPreCheckException preCheckException(Throwable t) {
        logger.error("", t);
        return new EBPreCheckException("", t);
    }

    public static EBPreCheckException preCheckException(String message, Throwable t) {
        logger.error(message, t);
        return new EBPreCheckException(message, t);
    }

    public static EBPreCheckException preCheckException(String errorCode, String message, Throwable t) {
        logger.error(message, t);
        return new EBPreCheckException(errorCode, message, t);
    }

    public static EBConnection connectionException(String message) {
        return new EBConnection(message);
    }

    public static EBConnection connectionException(Throwable t) {
        logger.error("", t);
        return new EBConnection("", t);
    }

    public static EBConnection connectionException(String message, Throwable t) {
        logger.error(message, t);
        return new EBConnection(message, t);
    }

    public static EBLoginAccessException loginAccessException(String message, Throwable t) {
        logger.error(message, t);
        return new EBLoginAccessException(message, t);
    }

    public static EBDuplicateException duplicateException(String message) {
        return new EBDuplicateException(message);
    }

    public static EBDuplicateException duplicateException(String message, Throwable t) {
        logger.error(message, t);
        return new EBDuplicateException(message, t);
    }

    public static EBDbSaveException dbSaveException(String message) {
        return new EBDbSaveException(message);
    }

    public static EBDbSaveException dbSaveException(String message, Throwable t) {
        logger.error(message, t);
        return new EBDbSaveException(message, t);
    }

    public static EBRePayException rePayException(String message) {
        return new EBRePayException(message);
    }

    @SdkDeprecated
    public static EBPayFailException payFailException(String message, Throwable t) {
        logger.error(message, t);
        return new EBPayFailException(message, t);
    }

    @SdkDeprecated
    public static EBPayFailException payFailException(String message) {
        return new EBPayFailException(message);
    }

    public static EBPayUnknownException payUnknownException(String message, Throwable t) {
        logger.error(message, t);
        return new EBPayUnknownException(message, t);
    }

    public static EBPayUnknownException payUnknownException(String message) {
        return new EBPayUnknownException(message);
    }

    public static String[] stackTrace(StackTraceElement[] stackTraceElements) {
        int length = stackTraceElements.length > 15 ? 15 : stackTraceElements.length;
        String[] stackTrace = new String[length];
        for (int i = 0; i < length; ++i) {
            stackTrace[i] = stackTraceElements[i].toString();
        }
        return stackTrace;
    }

    public static String stackTraceString(StackTraceElement[] stackTraceElements) {
        int length = stackTraceElements.length > 15 ? 15 : stackTraceElements.length;
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u9519\u8bef\u5f02\u5e38\u5806\u6808\uff1a", (String)"EBExceiptionUtil_0", (String)"ebg-egf-common", (Object[])new Object[0])).append('\n');
        for (int i = 0; i < length; ++i) {
            sb.append(stackTraceElements[i].toString()).append("\n");
        }
        return sb.toString();
    }

    public static EBYEFailException balFailException(String message, Throwable t) {
        logger.error(message, t);
        if (StringUtils.isEmpty(message)) {
            return new EBYEFailException(EBExceiptionUtil.yeRequestFailTemplate());
        }
        String template = String.format(EBExceiptionUtil.yeFailTemplate(), message);
        return new EBYEFailException(template);
    }

    public static EBPreYERequestException preYERequestException(String message, Throwable t) {
        logger.error(message, t);
        if (StringUtils.isEmpty(message)) {
            message = ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u6c42\u94f6\u884c\u4f59\u989d\u67e5\u8be2\u5904\u7406\u5f02\u5e38\uff0c\u8be6\u7ec6\u9519\u8bef\u8bf7\u5230\u201d\u67e5\u8be2\u4e0e\u652f\u4ed8>\u94f6\u4f01\u65e5\u5fd7\u201c\u67e5\u770b\u3002", (String)"EBExceiptionUtil_1", (String)"ebg-egf-common", (Object[])new Object[0]);
            return new EBPreYERequestException(message);
        }
        String template = String.format(EBExceiptionUtil.yeRequestErrorTemplate(), message);
        return new EBPreYERequestException(template);
    }

    public static EBConnection yeConnectionException(String bankLoginID, Throwable t) {
        String template = String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u94f6\u884c\u524d\u7f6e\u673a\u201c%1$s\u201d\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u5230\u201d\u67e5\u8be2\u4e0e\u652f\u4ed8>\u94f6\u4f01\u8fde\u63a5\u901a\u9053\u201c\u68c0\u67e5\u524d\u7f6e\u673a\u201c%2$s\u201d\u8fde\u63a5\u72b6\u6001\u3002", (String)"EBExceiptionUtil_2", (String)"ebg-egf-common", (Object[])new Object[0]), bankLoginID, bankLoginID);
        logger.error(template, t);
        return new EBConnection(template);
    }

    public static String emptyResponseData() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u94f6\u884c\u4f59\u989d\u67e5\u8be2\u672a\u54cd\u5e94\u4f59\u989d\u6570\u636e\uff0c\u8be6\u7ec6\u5185\u5bb9\u8bf7\u5230\u201d\u67e5\u8be2\u4e0e\u652f\u4ed8>\u94f6\u4f01\u65e5\u5fd7\u201c\u67e5\u770b\u3002", (String)"EBExceiptionUtil_3", (String)"ebg-egf-common", (Object[])new Object[0]);
    }

    public static String yeRequestErrorTemplate() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u6c42\u94f6\u884c\u4f59\u989d\u67e5\u8be2\u5904\u7406\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\u201d%s\u201c\uff0c\u8be6\u7ec6\u9519\u8bef\u8bf7\u5230\u201d\u67e5\u8be2\u4e0e\u652f\u4ed8>\u94f6\u4f01\u65e5\u5fd7\u201c\u67e5\u770b\u3002", (String)"EBExceiptionUtil_4", (String)"ebg-egf-common", (Object[])new Object[0]);
    }

    public static String yeRequestFailTemplate() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u8be6\u7ec6\u9519\u8bef\u8bf7\u5230\u201d\u67e5\u8be2\u4e0e\u652f\u4ed8>\u94f6\u4f01\u65e5\u5fd7\u201c\u67e5\u770b\u3002", (String)"EBExceiptionUtil_5", (String)"ebg-egf-common", (Object[])new Object[0]);
    }

    public static String yeFailTemplate() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u94f6\u884c\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\u539f\u56e0\u201d%s\u201c\uff0c\u8be6\u7ec6\u9519\u8bef\u8bf7\u5230\u201d\u67e5\u8be2\u4e0e\u652f\u4ed8>\u94f6\u4f01\u65e5\u5fd7\u201c\u67e5\u770b\u3002", (String)"EBExceiptionUtil_6", (String)"ebg-egf-common", (Object[])new Object[0]);
    }

    public static String identifyYEException(Throwable t) {
        if (Objects.isNull(t)) {
            return EBExceiptionUtil.yeRequestFailTemplate();
        }
        if (t instanceof EBConnection || t instanceof EBPreYERequestException || t instanceof EBYEFailException) {
            return t.getMessage();
        }
        if (Objects.isNull(t.getCause())) {
            return String.format(EBExceiptionUtil.yeFailTemplate(), t.getMessage());
        }
        return String.format(EBExceiptionUtil.yeFailTemplate(), t.getCause().getMessage());
    }

    public static String missPayRouteTemplate() {
        return ResManager.loadKDString((String)"\u201c%1$s\u201d\u6682\u672a\u5b9e\u73b0\u201c%2$s\u201d\uff0c\u53ef\u901a\u8fc7\u201c\u67e5\u8be2\u4e0e\u652f\u4ed8>\u94f6\u884c\u4ed8\u6b3e\u8def\u7531\u56fe/\u94f6\u884c\u63a5\u53e3\u652f\u6301\u60c5\u51b5\u201d\u67e5\u770b\u201c%1$s\u201d\u4e1a\u52a1\u652f\u6301\u80fd\u529b\u540e\uff0c\u901a\u8fc7\u201c\u67e5\u8be2\u4e0e\u652f\u4ed8>\u94f6\u884c\u4ed8\u6b3e\u63a5\u53e3\u89c4\u5219\u201d\u81ea\u884c\u914d\u7f6e\u53ef\u4f7f\u7528\u63a5\u53e3\u3002", (String)"EBExceiptionUtil_7", (String)"ebg-egf-common", (Object[])new Object[0]);
    }

    public static String missPayRoute(String bankName, String bizName) {
        return String.format(EBExceiptionUtil.missPayRouteTemplate(), bankName, bizName);
    }
}

