/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.communication;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.protocol.HttpClient;
import kd.ebg.egf.common.utils.string.StringUtils;

public class HttpConnection
implements IConnection {
    public static final String REQUEST_METHOD_POST = "POST";
    public static final String REQUEST_METHOD_GET = "GET";
    public static final String REQUEST_METHOD = "Request Method";
    private HttpClient httpClient;
    private String host;
    private int port;
    private String uri;
    private Map<String, String> header;
    private int timeout;
    private String method;

    public HttpConnection(String host, int port, String uri, Map<String, String> header, int timeout) {
        this(host, port, uri, header, timeout, REQUEST_METHOD_POST);
    }

    public HttpConnection(String host, int port, String uri, Map<String, String> header, int timeout, String method) {
        this.host = host;
        this.port = port;
        this.uri = uri;
        this.header = header;
        this.timeout = timeout;
        this.method = method;
    }

    @Override
    public void openConnection() throws IOException {
        this.httpClient = new HttpClient(this.host, this.port, this.uri, this.header, this.timeout, this.method);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.httpClient.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.httpClient.getOutputStream();
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.httpClient.getResponseCode();
    }

    @Override
    public void closeConnection() {
        this.httpClient.closeConnection();
    }

    @Override
    public String getUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append("http://").append(this.host).append(':').append(this.port);
        if (!StringUtils.isEmpty(this.uri)) {
            if (this.uri.startsWith("/")) {
                sb.append(this.uri);
            } else {
                sb.append('/').append(this.uri);
            }
        }
        return sb.toString();
    }
}

