/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.communication;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.SocketException;
import java.security.KeyStore;
import java.util.Base64;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBLoginConnection;
import kd.ebg.egf.common.exception.EBSSLConnection;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.bean.OTRequest;
import kd.ebg.egf.common.framework.communication.bean.OTResponse;
import kd.ebg.egf.common.framework.communication.util.CertReader;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.framework.communication.util.ProxySignature;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.proxy.BankLoginProxyConfig;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StrUtil;

public class SSLConnection
implements IConnection {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(SSLConnection.class);
    protected IConnection connection;
    public static final int CFCA_PROXY = 1;
    public static final int SSL_PROXY = 2;
    private String DEFAULT_HOST;
    private int DEFAULT_PORT;
    private String CLIENT_KEY_STORE;
    private String CLIENT_TRUST_KEY_STORE;
    private String CLIENT_KEY_STORE_ALIAS = "";
    private String CLIENT_TRUST_KEY_STORE_ALIAS = "";
    private String CLIENT_KEY_STORE_PASSWORD;
    private String CLIENT_TRUST_KEY_STORE_PASSWORD;
    private String RSA_SIGN_ALGO = "sha256";
    private String host;
    private String port;
    private String uri;
    private Map<String, String> header;
    private String method;
    private String remoteUrl;
    private String protocol;
    private String charset;
    private String requestSeqID;
    private int proxyType;
    private String response;
    private SSLContext ctx;
    public static final int PACKETSIZE = 65535;
    private SSLSocket sslSocket;
    private BankLoginProxyConfig proxyConfig;
    private int timeout = 3;
    public static int CONNECT_TEST_TIME_OUT = 10000;
    private static final String APPLICATION_XML_VALUE = "application/xml";

    private static void writeLog(String type, String message) {
        if (StringUtils.isEmpty((String)EBContext.getContext().getLogBizSeqID())) {
            EBContext.getContext().setLogBizSeqID(Sequence.gen18Sequence());
        }
        EBContext.getContext().setType(type);
        logger.infoFilerLog(message);
    }

    public SSLConnection(IConnection connection, String protocol, String ip, int port, int timeout, Map<String, String> protocolKey, Map<String, String> httpHeaders, String charset, EBContext context) {
        this.connection = connection;
        this.host = ip;
        this.port = String.valueOf(port);
        this.header = httpHeaders;
        this.protocol = protocol;
        this.charset = charset;
        this.proxyType = context.getProxyType();
        this.timeout = timeout > 0 ? timeout : 3;
        this.proxyConfig = context.getProxyConfig();
        if (!this.header.containsKey("Content-Type") && !this.header.containsKey("content-type")) {
            this.header.put("Content-Type", APPLICATION_XML_VALUE);
        }
        if ("HTTP".equalsIgnoreCase(protocol) || "HTTPS".equalsIgnoreCase(protocol)) {
            this.uri = protocolKey.get("uri");
            this.method = httpHeaders.get("Request Method");
            if (StrUtil.isBlank(this.method)) {
                this.method = "POST";
            } else {
                httpHeaders.remove("Request Method");
            }
        } else if (!"TCP".equalsIgnoreCase(protocol)) {
            throw EBExceiptionUtil.connectionException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u534f\u8bae\u7c7b\u578b ", (String)"SSLConnection_0", (String)"ebg-egf-common", (Object[])new Object[0]), protocol));
        }
        this.remoteUrl = this.getUrl();
    }

    public void init() throws IOException {
        this.LoadKeyStoreFromDB();
        this.signInit();
        this.createSSLInit();
    }

    private void LoadKeyStoreFromDB() throws IOException {
        this.DEFAULT_HOST = this.proxyConfig.getProxyHost();
        this.DEFAULT_PORT = Integer.parseInt(this.proxyConfig.getProxyPort());
        if (this.proxyConfig.getPrivateKey() == null) {
            throw new IOException(ResManager.loadKDString((String)"\u524d\u7f6e\u673a\u4ee3\u7406\u79c1\u94a5\u4e3a\u7a7a\u3002", (String)"SSLConnection_1", (String)"ebg-egf-common", (Object[])new Object[0]));
        }
        this.CLIENT_KEY_STORE = Base64.getEncoder().encodeToString(DesUtil.decryptProxyCert(this.proxyConfig.getPrivateKey(), RequestContext.get().getTenantId(), this.proxyConfig.getPrivateCertCipherVer(), this.proxyConfig.getPrivateCertID()));
        this.CLIENT_KEY_STORE_PASSWORD = DesUtil.decryptPwd(this.proxyConfig.getPrivateKeySecret(), RequestContext.get().getTenantId(), "aqap_proxy_config", this.proxyConfig.getProxyID(), "private_key_secret");
        this.CLIENT_KEY_STORE_ALIAS = this.proxyConfig.getPrivateKeyAlias();
        this.CLIENT_TRUST_KEY_STORE_ALIAS = this.proxyConfig.getPublicKeyAlias();
        this.RSA_SIGN_ALGO = this.proxyConfig.getRsaSignAlgo();
        if (StringUtils.isEmpty((String)this.RSA_SIGN_ALGO)) {
            this.RSA_SIGN_ALGO = "sha256";
        }
        if (this.proxyConfig.getPublicKey() == null) {
            throw new IOException(ResManager.loadKDString((String)"\u524d\u7f6e\u673a\u4ee3\u7406\u516c\u94a5\u4e3a\u7a7a\u3002", (String)"SSLConnection_2", (String)"ebg-egf-common", (Object[])new Object[0]));
        }
        this.CLIENT_TRUST_KEY_STORE = Base64.getEncoder().encodeToString(DesUtil.decryptProxyCert(this.proxyConfig.getPublicKey(), RequestContext.get().getTenantId(), this.proxyConfig.getPublicCertCipherVer(), this.proxyConfig.getPublicCertID()));
        this.CLIENT_TRUST_KEY_STORE_PASSWORD = DesUtil.decryptPwd(this.proxyConfig.getPublicKeySecret(), RequestContext.get().getTenantId(), "aqap_proxy_config", this.proxyConfig.getProxyID(), "public_key_secret");
    }

    private void signInit() {
        byte[] clientKeyBytes = Base64.getDecoder().decode(this.CLIENT_KEY_STORE);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(clientKeyBytes);
        CertReader.setKeyStoreTypr("JKS");
        CertReader reader = new CertReader(inputStream, this.CLIENT_KEY_STORE_PASSWORD, this.CLIENT_KEY_STORE_ALIAS);
        reader.setName("PRIVATEKEY");
        try {
            reader.initKeyStore();
            ProxySignature signature = new ProxySignature(reader.getPublicKey(), reader.getPrivateKey());
            if (1 == this.proxyType) {
                signature.init("SHA256withRSA");
            } else if (reader.getPublicKey().getAlgorithm().contains("DSA")) {
                signature.init("SHA1withDSA");
            } else if (this.RSA_SIGN_ALGO.equalsIgnoreCase("sha1")) {
                signature.init("SHA1withRSA");
            } else {
                signature.init("SHA256withRSA");
            }
            EBContext.getContext().setSignature(signature);
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u521d\u59cb\u5316\u7b7e\u540d\u5bc6\u94a5\u51fa\u73b0\u5f02\u5e38\uff1a%s\u3002", (String)"SSLConnection_3", (String)"ebg-egf-common", (Object[])new Object[0]) + "\n", ex.getMessage()), ex);
        }
        if (2 == this.proxyType) {
            byte[] clientTrustKeyBytes = Base64.getDecoder().decode(this.CLIENT_TRUST_KEY_STORE);
            inputStream = new ByteArrayInputStream(clientTrustKeyBytes);
            CertReader.setKeyStoreTypr("JKS");
            CertReader cer_reader = new CertReader(inputStream, this.CLIENT_TRUST_KEY_STORE_PASSWORD, this.CLIENT_TRUST_KEY_STORE_ALIAS);
            cer_reader.setName("PUBLICKEY");
            try {
                cer_reader.initKeyStore();
                ProxySignature verifySignature = new ProxySignature(cer_reader.getPublicKey(this.CLIENT_TRUST_KEY_STORE_ALIAS));
                if (cer_reader.getPublicKey(this.CLIENT_TRUST_KEY_STORE_ALIAS).getAlgorithm().contains("DSA")) {
                    verifySignature.init("SHA1withDSA");
                } else if (this.RSA_SIGN_ALGO.equalsIgnoreCase("sha1")) {
                    verifySignature.init("SHA1withRSA");
                } else {
                    verifySignature.init("SHA256withRSA");
                }
                EBContext.getContext().setVerifySignature(verifySignature);
            }
            catch (Exception ex) {
                throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u521d\u59cb\u5316\u9a8c\u8bc1\u7b7e\u540d\u5bc6\u94a5\u51fa\u73b0\u5f02\u5e38\uff1a%s\u3002", (String)"SSLConnection_4", (String)"ebg-egf-common", (Object[])new Object[0]) + "\n", ex.getMessage()), ex);
            }
        }
    }

    private void createSSLInit() {
        this.sslSocketInit();
    }

    private void sslSocketInit() {
        try {
            this.ctx = SSLContext.getInstance("TLS");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            KeyStore ks = KeyStore.getInstance("JKS");
            KeyStore tks = KeyStore.getInstance("JKS");
            byte[] clientKeyBytes = Base64.getDecoder().decode(this.CLIENT_KEY_STORE);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(clientKeyBytes);
            ks.load(inputStream, this.CLIENT_KEY_STORE_PASSWORD.toCharArray());
            clientKeyBytes = Base64.getDecoder().decode(this.CLIENT_TRUST_KEY_STORE);
            inputStream = new ByteArrayInputStream(clientKeyBytes);
            tks.load(inputStream, this.CLIENT_TRUST_KEY_STORE_PASSWORD.toCharArray());
            kmf.init(ks, this.CLIENT_KEY_STORE_PASSWORD.toCharArray());
            tmf.init(tks);
            this.ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            this.sslSocket = (SSLSocket)this.ctx.getSocketFactory().createSocket(this.DEFAULT_HOST, this.DEFAULT_PORT);
            this.sslSocket.setSoTimeout(this.timeout * 60 * 1000);
            try {
                String reTimeOut = RequestContextUtils.getRunningParam("timeout");
                if (StringUtils.isNotEmpty((String)reTimeOut)) {
                    this.sslSocket.setSoTimeout(Integer.parseInt(reTimeOut));
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            if (e instanceof ConnectException) {
                throw new IllegalStateException(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u4e0e\u7f51\u7edc\u4ee3\u7406\u5efa\u7acbSSL\u8fde\u63a5\u5931\u8d25\uff0c%s", (String)"SSLConnection_5", (String)"ebg-egf-common", (Object[])new Object[0]), e.getMessage()), e);
            }
            throw new IllegalStateException(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u4e0e\u7f51\u7edc\u4ee3\u7406\u901a\u4fe1\u4e2d\u65ad\uff0c\u521d\u59cb\u5316ssl\u8fde\u63a5\u51fa\u73b0\u5f02\u5e38\uff0c%s", (String)"SSLConnection_6", (String)"ebg-egf-common", (Object[])new Object[0]), e.getMessage()), e);
        }
    }

    public String getResponse(InputStream inputStream) {
        if (1 == this.proxyType) {
            OTResponse rsp = (OTResponse)JSON.parseObject((String)this.response, OTResponse.class);
            if (this.verifySignedData(rsp.getSignature(), rsp.getData())) {
                return rsp.getData();
            }
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u9a8c\u8bc1\u54cd\u5e94\u62a5\u6587\u7b7e\u540d\u5931\u8d25\u3002", (String)"SSLConnection_8", (String)"ebg-egf-common", (Object[])new Object[0]));
        }
        String rsqStr = IOUtils.readFully(inputStream, "UTF-8");
        OTResponse response = (OTResponse)JSON.parseObject((String)rsqStr, OTResponse.class);
        if (this.verifySignedData(response.getSignature(), response.getData())) {
            if (response.isException()) {
                EBContext.getContext().setType("response");
                logger.infoFilerLog(String.format(ResManager.loadKDString((String)"SSL\u63a5\u6536\u5230\u7684\u54cd\u5e94%1$s\uff0c%2$s\u3002", (String)"SSLConnection_9", (String)"ebg-egf-common", (Object[])new Object[0]), "\n", response.getData()));
                throw EBExceiptionUtil.serviceException(response.getData(), response.getErrorCode());
            }
            return response.getData();
        }
        throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u9a8c\u8bc1\u54cd\u5e94\u62a5\u6587\u7b7e\u540d\u5931\u8d25\u3002", (String)"SSLConnection_8", (String)"ebg-egf-common", (Object[])new Object[0]));
    }

    public void sendMsg(OutputStream outputStream, String requestUrl) {
        if (Strings.isNullOrEmpty((String)requestUrl)) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u8981\u53d1\u9001\u7684\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"SSLConnection_10", (String)"ebg-egf-common", (Object[])new Object[0]));
        }
        try {
            byte[] buffer = this.getRequest(requestUrl).getBytes("UTF-8");
            int off = 0;
            int len = buffer.length;
            int writeLen = 0;
            int count = 0;
            while (len > count * 65535) {
                writeLen = len - off;
                if (writeLen > 65535) {
                    writeLen = 65535;
                }
                outputStream.write(buffer, off, writeLen);
                off = ++count * 65535;
            }
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u6570\u636e\u53d1\u9001\u81f3\u7f51\u7edc\u4ee3\u7406\u5931\u8d25\uff0c%s\u3002", (String)"SSLConnection_11", (String)"ebg-egf-common", (Object[])new Object[0]), e.getMessage()), e);
        }
    }

    public String getRequest(String requestUrl) {
        OTRequest request = new OTRequest();
        if (requestUrl.startsWith("#")) {
            String[] str = requestUrl.split("#");
            this.protocol = str[1];
            requestUrl = requestUrl.substring(this.protocol.length() + 2, requestUrl.length());
        }
        if ("HTTP".equalsIgnoreCase(this.protocol)) {
            request.setProxyType("HTTP");
        } else if ("TCP".equalsIgnoreCase(this.protocol)) {
            request.setProxyType("TCP");
        } else if ("HTTPS".equalsIgnoreCase(this.protocol)) {
            request.setProxyType("HTTPS");
        } else {
            request.setProxyType(this.protocol);
            if ("ping".equalsIgnoreCase(this.protocol)) {
                this.setTimeout(CONNECT_TEST_TIME_OUT);
            }
        }
        request.setRemoteURL(this.remoteUrl);
        request.setData(requestUrl);
        if (StrUtil.isBlank(this.method)) {
            this.method = "POST";
        }
        request.setHttpMethod(this.method);
        request.setSignedData("");
        request.setRemoteEncode(this.charset);
        request.setHttpHeaders(JSONObject.toJSONString(this.header));
        String signPlainText = request.getPlainText(this.proxyType);
        request.setSignPlainText(signPlainText);
        try {
            request.setSignedData(EBContext.getContext().getSignature().sign(signPlainText.getBytes("UTF-8")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String reqStr = JSON.toJSONString((Object)request);
        SSLConnection.writeLog("request", String.format(ResManager.loadKDString((String)"SSL\u53d1\u9001\u51fa\u7684\u8bf7\u6c42\uff1a%1$s %2$s\u3002", (String)"SSLConnection_12", (String)"ebg-egf-common", (Object[])new Object[0]), "\n", request.getData()));
        int len = 0;
        try {
            len = reqStr.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.toString());
        }
        reqStr = len + "#" + reqStr;
        return reqStr;
    }

    public boolean verifySignedData(String signedData, String data) {
        String charset = "UTF-8";
        try {
            return EBContext.getContext().getVerifySignature().verify(signedData, data.getBytes(charset));
        }
        catch (Exception e) {
            return false;
        }
    }

    private void setTimeout(int timeout) {
        try {
            if (this.sslSocket != null) {
                this.sslSocket.setSoTimeout(timeout);
            }
        }
        catch (SocketException e) {
            throw EBExceiptionUtil.serviceException("set SSLConnect time out error", e);
        }
    }

    @Override
    public void openConnection() throws IOException {
        this.init();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (1 == this.proxyType) {
            return null;
        }
        return this.sslSocket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (1 == this.proxyType) {
            return null;
        }
        return this.sslSocket.getOutputStream();
    }

    @Override
    public int getResponseCode() throws IOException {
        return 200;
    }

    @Override
    public void closeConnection() {
        try {
            this.sslSocket.close();
        }
        catch (Exception e) {
            logger.info(e.toString());
        }
    }

    @Override
    public String getUrl() {
        return this.connection.getUrl();
    }

    public void connectionTest(SSLSocket sslSocket, String frontIP, String frontPort) throws IOException {
        boolean isConnected;
        this.setTimeout(CONNECT_TEST_TIME_OUT);
        boolean bl = isConnected = sslSocket != null && sslSocket.isConnected();
        if (!isConnected) {
            try {
                if (sslSocket != null) {
                    sslSocket.close();
                }
            }
            catch (IOException e) {
                throw new EBSSLConnection(String.format(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u524d\u7f6e\u673a\u4ee3\u7406\u4e0d\u901a\u3002", (String)"SSLConnection_13", (String)"ebg-egf-common", (Object[])new Object[0]), e.getMessage()));
            }
            throw new EBSSLConnection(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u7f51\u7edc\u4ee3\u7406\u4e0d\u901a\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u4ee3\u7406\u8fd0\u884c\u60c5\u51b5\u3002", (String)"SSLConnection_14", (String)"ebg-egf-common", (Object[])new Object[0]));
        }
        String data = "#ping#[{\"bankLoginId\":\"test\",\"bankLoginName\":\"Test\",\"bankVersionId\":\"Test\",\"email\":\"test\",\"ip\":\"" + frontIP + "\",\"phoneNum\":\"test\",\"ping\":true,\"port\":" + frontPort + "}]";
        try {
            this.sendMsg(sslSocket.getOutputStream(), data);
            String rep = this.getResponse(sslSocket.getInputStream());
            if (!rep.contains(PropertiesConstants.getValue("NORMAL_COMMUNICATION"))) {
                throw new EBLoginConnection(ResManager.loadKDString((String)"\u94f6\u884c\u524d\u7f6e\u673a\u8fde\u63a5\u4e0d\u901a\uff0c\u8bf7\u68c0\u67e5\u94f6\u884c\u524d\u7f6e\u673a\u8fd0\u884c\u60c5\u51b5\u3002", (String)"SSLConnection_15", (String)"ebg-egf-common", (Object[])new Object[0]));
            }
        }
        catch (IOException e) {
            if (sslSocket != null) {
                sslSocket.close();
            }
            throw new EBSSLConnection(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u7f51\u7edc\u4ee3\u7406\u4e0d\u901a\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u4ee3\u7406\u8fd0\u884c\u60c5\u51b5\u3002", (String)"SSLConnection_14", (String)"ebg-egf-common", (Object[])new Object[0]));
        }
    }
}

