/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.frame;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.bos.id.ID;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankSerialNo;
import kd.ebg.egf.common.repository.BankSerialNoRepository;
import kd.ebg.egf.common.utils.BankIncreasingSequenceUtil;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.annotation.SdkDeprecated;

public class Sequence {
    private static Sequence instance = new Sequence();
    private static long firstAccessTime = System.currentTimeMillis();
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v'};
    private static final char[] hex29Digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's'};
    private static final char[] hex23Digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm'};
    private static final char[] hex15Digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e'};
    private static final char[] hex62Digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'a', 'B', 'b', 'C', 'c', 'D', 'd', 'E', 'e', 'F', 'f', 'G', 'g', 'H', 'h', 'I', 'i', 'J', 'j', 'K', 'k', 'L', 'l', 'M', 'm', 'N', 'n', 'O', 'o', 'P', 'p', 'Q', 'q', 'R', 'r', 'S', 's', 'T', 't', 'U', 'u', 'V', 'v', 'W', 'w', 'X', 'x', 'Y', 'y', 'Z', 'z'};

    public static Sequence getInstance() {
        return instance;
    }

    public static synchronized boolean init() {
        if (firstAccessTime <= 0L) {
            firstAccessTime = System.currentTimeMillis();
        }
        return true;
    }

    public static synchronized String gen8Sequence() {
        String sequence;
        long id;
        boolean exsist;
        BankSerialNoRepository bankSerialNoRepository = BankSerialNoRepository.getInstance();
        EBContext context = EBContext.getContext();
        do {
            id = ID.genLongId() + 200000000000000000L;
            sequence = String.valueOf(id);
            id = Long.parseLong(sequence.substring(0, 14));
            BankSerialNo bankSerialNo = new BankSerialNo();
            bankSerialNo.setBankVersionId(context.getBankVersionID());
            bankSerialNo.setCustomId(context.getCustomID());
            bankSerialNo.setNumber(id + "");
            try {
                bankSerialNoRepository.save(bankSerialNo);
                exsist = false;
            }
            catch (Throwable e) {
                exsist = true;
            }
        } while (exsist);
        sequence = Sequence.toMaxScale(id);
        return sequence;
    }

    public static synchronized String genSequence() {
        long id = ID.genLongId() + 200000000000000000L;
        return Sequence.to19_13Scale(id);
    }

    public static synchronized String gen14Sequence() {
        long id = ID.genLongId() + 200000000000000000L;
        return Sequence.to19_14Scale(id);
    }

    private static long getAutoIncSerialNo() {
        long result;
        EBContext context = EBContext.getContext();
        String bankVersionId = context.getBankVersionID();
        String CustomId = context.getCustomID();
        String prefix = DateTimeUtils.format(new Date(), "yyMMdd");
        try {
            result = BankIncreasingSequenceUtil.getIncreasingSequence(bankVersionId + CustomId + prefix);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException("gen serial no error", e);
        }
        return result;
    }

    public static String getAutoincrementNumber(int n) {
        long maxNum = Math.round(Math.pow(10.0, n) - 1.0);
        long result = Sequence.getAutoIncSerialNo();
        if (result > maxNum) {
            throw EBExceiptionUtil.serviceException("serialNo is larger than maxNum, actual value=" + result);
        }
        return String.format("%0" + n + "d", result);
    }

    @SdkDeprecated
    public static String getUniqueincrementNumber(int n, String prefixCache) {
        if (StringUtils.isEmpty(prefixCache)) {
            throw EBExceiptionUtil.serviceException("param prefixCache is null ");
        }
        long maxNum = Math.round(Math.pow(10.0, n) - 1.0);
        long result = Sequence.getUniqueAutoIncSerialNo(prefixCache);
        String prefix = DateTimeUtils.format(new Date(), "yyyyMMdd");
        if (result > maxNum) {
            throw EBExceiptionUtil.serviceException("serialNo is larger than maxNum, actual value=" + result);
        }
        return prefix + String.format("%0" + n + "d", result);
    }

    private static long getUniqueAutoIncSerialNo(String prefixCache) {
        long result;
        EBContext context = EBContext.getContext();
        String bankVersionId = context.getBankVersionID();
        String CustomId = context.getCustomID();
        String prefix = DateTimeUtils.format(new Date(), "yyMMdd") + prefixCache;
        try {
            result = BankIncreasingSequenceUtil.getIncreasingSequence(bankVersionId + CustomId + prefix);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException("gen serial no error", e);
        }
        return result;
    }

    public static String getAutoincrementNumber(int start, int n) {
        long maxNum = Math.round(Math.pow(10.0, n) - 1.0);
        long result = 0L;
        while (result < (long)start) {
            result = Sequence.getAutoIncSerialNo();
        }
        if (result > maxNum) {
            result = maxNum;
        }
        return String.format("%0" + n + "d", result);
    }

    public static String getAutoincrementNumberWithCycle(int n) {
        long maxNum = Math.round(Math.pow(10.0, n) - 1.0);
        long result = Sequence.getAutoIncSerialNo();
        if (result > maxNum) {
            result %= maxNum;
        }
        return String.format("%0" + n + "d", result);
    }

    public static String genDateTimeAnd6NumSequence() {
        String prefix = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        String autoincrementNumber = Sequence.getAutoincrementNumber(6);
        return prefix + autoincrementNumber;
    }

    public static synchronized long gen16NumSequence() {
        long id;
        boolean exsist;
        BankSerialNoRepository bankSerialNoRepository = BankSerialNoRepository.getInstance();
        EBContext context = EBContext.getContext();
        do {
            id = ID.genLongId() + 200000000000000000L;
            String sequence = String.valueOf(id);
            id = Long.parseLong(sequence.substring(0, 16));
            BankSerialNo bankSerialNo = new BankSerialNo();
            bankSerialNo.setBankVersionId(context.getBankVersionID());
            bankSerialNo.setCustomId(context.getCustomID());
            bankSerialNo.setNumber(id + "");
            try {
                bankSerialNoRepository.save(bankSerialNo);
                exsist = false;
            }
            catch (Throwable e) {
                exsist = true;
            }
        } while (exsist);
        return id;
    }

    public static synchronized String gen16Sequence() {
        long id = ID.genLongId() + 200000000000000000L;
        return Sequence.to19_16Scale(id);
    }

    public static synchronized String gen18Sequence() {
        long id = ID.genLongId() + 200000000000000000L;
        String sequence = String.valueOf(id);
        return sequence;
    }

    public static String to32Scale(long x) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 13; ++i) {
            char c = hexDigits[(int)(x & 0x1FL)];
            sb.insert(0, c);
            x >>>= 5;
        }
        return new String(sb);
    }

    public static String to8Scale(long x) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            char c = hexDigits[(int)(x & 0x1FL)];
            sb.insert(0, c);
            x >>>= 5;
        }
        return new String(sb);
    }

    public static String to19_13Scale(long v) {
        StringBuilder sb = new StringBuilder(6);
        do {
            int mod = (int)(v % 29L);
            sb.append(hex29Digits[mod]);
        } while ((v /= 29L) != 0L);
        return sb.reverse().toString();
    }

    public static String to19_14Scale(long v) {
        StringBuilder sb = new StringBuilder(6);
        do {
            int mod = (int)(v % 23L);
            sb.append(hex23Digits[mod]);
        } while ((v /= 23L) != 0L);
        return sb.reverse().toString();
    }

    public static String to19_16Scale(long v) {
        StringBuilder sb = new StringBuilder(6);
        do {
            int mod = (int)(v % 15L);
            sb.append(hex15Digits[mod]);
        } while ((v /= 15L) != 0L);
        return sb.reverse().toString();
    }

    public static String toMaxScale(long v) {
        StringBuilder sb = new StringBuilder(6);
        do {
            int mod = (int)(v % 62L);
            sb.append(hex62Digits[mod]);
        } while ((v /= 62L) != 0L);
        return sb.reverse().toString();
    }
}

