/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.security;

import java.util.HashMap;
import java.util.Map;
import kd.ebg.egf.common.framework.security.atomic.IEncrypt;
import kd.ebg.egf.common.framework.security.atomic.ISignature;
import kd.ebg.egf.common.framework.security.sign.other.AESEBEncrypt;
import kd.ebg.egf.common.framework.security.sign.other.AlgorithmEnum;
import kd.ebg.egf.common.framework.security.sign.other.DESEBEncrypt;
import kd.ebg.egf.common.framework.security.sign.other.DESedeEBEncrypt;
import kd.ebg.egf.common.framework.security.sign.other.DSAEBSignature;
import kd.ebg.egf.common.framework.security.sign.other.RSA256EBSignature;
import kd.ebg.egf.common.framework.security.sign.other.RSAEBEncrypt;
import kd.ebg.egf.common.framework.security.sign.other.RSAEBSignature;
import kd.ebg.egf.common.framework.security.sign.other.RSANoPaddingEncrypt;

public class EBSecurityCatalog {
    private static Map<String, Class<? extends IEncrypt>> EBEncryptStore = new HashMap<String, Class<? extends IEncrypt>>(10);
    private static Map<String, Class<? extends ISignature>> EBSignatureStore = new HashMap<String, Class<? extends ISignature>>(10);

    public static void registerEncrypt(String algorithm, Class<IEncrypt> encrypterClass) {
        EBEncryptStore.put(algorithm, encrypterClass);
    }

    public static void registerSignature(String algorithm, Class<ISignature> signaturerClass) {
        EBSignatureStore.put(algorithm, signaturerClass);
    }

    public static Class<? extends IEncrypt> getEncrypt(String algorithm) {
        return EBEncryptStore.get(algorithm);
    }

    public static Class<? extends ISignature> getSignature(String algorithm) {
        return EBSignatureStore.get(algorithm);
    }

    static {
        EBEncryptStore.put(AlgorithmEnum.AES.getAlgorithm(), AESEBEncrypt.class);
        EBEncryptStore.put(AlgorithmEnum.DES.getAlgorithm(), DESEBEncrypt.class);
        EBEncryptStore.put(AlgorithmEnum.DESede.getAlgorithm(), DESedeEBEncrypt.class);
        EBSignatureStore.put(AlgorithmEnum.SHA1withRAS.getAlgorithm(), RSAEBSignature.class);
        EBSignatureStore.put(AlgorithmEnum.SHA256withRAS.getAlgorithm(), RSA256EBSignature.class);
        EBSignatureStore.put(AlgorithmEnum.SHA1withDSA.getAlgorithm(), DSAEBSignature.class);
        EBEncryptStore.put(AlgorithmEnum.RSA.getAlgorithm(), RSAEBEncrypt.class);
        EBEncryptStore.put(AlgorithmEnum.RSANoPadding.getAlgorithm(), RSANoPaddingEncrypt.class);
    }
}

