/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.security.atomic;

import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.exception.EBSecurityException;
import kd.ebg.egf.common.framework.security.atomic.AbstractEBSecurityBase;
import kd.ebg.egf.common.framework.security.atomic.ISignature;
import org.bouncycastle.util.encoders.Base64;

public abstract class AbstractEBSignature
extends AbstractEBSecurityBase
implements ISignature {
    protected Signature signature;
    protected Signature signatureVerify;
    private byte[] publicKeyBytes;

    public AbstractEBSignature(byte[] keyBytes, byte[] publicKeyBytes) {
        super(keyBytes);
        this.publicKeyBytes = publicKeyBytes;
        this.init();
    }

    @Override
    public void init() {
        super.init();
        try {
            this.signature = Signature.getInstance(this.getAlgorithm());
            this.signature.initSign((PrivateKey)this.getPrivateKey());
            this.signatureVerify = Signature.getInstance(this.getAlgorithm());
            this.signatureVerify.initVerify((PublicKey)this.getPublicKey());
        }
        catch (Exception e) {
            throw new EBSecurityException(e);
        }
    }

    public Key getPublicKey() {
        X509EncodedKeySpec pkcs8KeySpec = new X509EncodedKeySpec(this.publicKeyBytes);
        PublicKey publicKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(this.getKeyAlgorithm());
            publicKey = keyFactory.generatePublic(pkcs8KeySpec);
        }
        catch (Exception e) {
            throw new EBSecurityException(e);
        }
        return publicKey;
    }

    public Key getPrivateKey() {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(this.getKeyBytes());
        PrivateKey privateKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(this.getKeyAlgorithm());
            privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        }
        catch (Exception e) {
            throw new EBSecurityException(e);
        }
        return privateKey;
    }

    @Override
    public String sign(byte[] source) {
        String signedStr = null;
        byte[] result = null;
        try {
            this.signature.update(source);
            result = this.signature.sign();
        }
        catch (Exception e) {
            throw new EBSecurityException(e);
        }
        signedStr = Base64.toBase64String((byte[])result);
        return signedStr;
    }

    @Override
    public boolean verify(String sign, byte[] content) {
        boolean flag = false;
        if (StringUtils.isEmpty((String)sign)) {
            return flag;
        }
        byte[] signedByte = Base64.decode((String)sign);
        try {
            this.signatureVerify.update(content);
            flag = this.signatureVerify.verify(signedByte);
        }
        catch (Exception e) {
            throw new EBSecurityException(e);
        }
        return flag;
    }
}

