/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.security.factory;

import java.lang.reflect.Constructor;
import kd.ebg.egf.common.exception.EBSecurityException;
import kd.ebg.egf.common.framework.security.EBSecurityCatalog;
import kd.ebg.egf.common.framework.security.atomic.IEncrypt;
import kd.ebg.egf.common.framework.security.atomic.ISignature;
import kd.ebg.egf.common.framework.security.sign.other.AlgorithmEnum;
import kd.ebg.egf.common.framework.security.sign.other.RSA256EBSignature;
import kd.ebg.egf.common.framework.security.sign.other.RSAEBSignature;

public enum EBSecurityFactory {
    INSTANCE;


    public IEncrypt getEBEncrypt(String algorithm, byte[] encryptKey) {
        IEncrypt ebEncrypt = null;
        Class<? extends IEncrypt> classEncrypt = EBSecurityCatalog.getEncrypt(algorithm);
        try {
            Constructor<? extends IEncrypt> constructor = classEncrypt.getConstructor(byte[].class);
            ebEncrypt = constructor.newInstance(new Object[]{encryptKey});
        }
        catch (Exception e) {
            throw new EBSecurityException(e);
        }
        return ebEncrypt;
    }

    public IEncrypt getEBEncrypt(String algorithm, byte[] privateKey, byte[] publicKey) {
        IEncrypt ebEncrypt = null;
        Class<? extends IEncrypt> classEncrypt = EBSecurityCatalog.getEncrypt(algorithm);
        try {
            Constructor<? extends IEncrypt> constructor = classEncrypt.getConstructor(byte[].class, byte[].class, Integer.TYPE);
            int mode = 3;
            if (null == privateKey) {
                mode = 1;
            }
            if (null == publicKey) {
                mode = 2;
            }
            ebEncrypt = constructor.newInstance(privateKey, publicKey, mode);
        }
        catch (Exception e) {
            throw new EBSecurityException(e);
        }
        return ebEncrypt;
    }

    public ISignature getEBSignature(String algorithm, byte[] privateKey, byte[] publicKey) {
        ISignature ebSignature = null;
        if (AlgorithmEnum.SHA1withRAS.getAlgorithm().equalsIgnoreCase(algorithm)) {
            ebSignature = new RSAEBSignature(privateKey, publicKey);
        } else if (AlgorithmEnum.SHA256withRAS.getAlgorithm().equalsIgnoreCase(algorithm)) {
            ebSignature = new RSA256EBSignature(privateKey, publicKey);
        } else {
            Class<? extends ISignature> classSignature = EBSecurityCatalog.getSignature(algorithm);
            try {
                Constructor<? extends ISignature> constructor = classSignature.getConstructor(byte[].class, byte[].class);
                ebSignature = constructor.newInstance(privateKey, publicKey);
            }
            catch (Exception e) {
                throw new EBSecurityException(e);
            }
        }
        return ebSignature;
    }
}

