/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.security.manage;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import kd.ebg.egf.common.framework.security.manage.AbstractCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.codec.binary.Base64;

public class AESCipherSecurity
extends AbstractCipherSecurity {
    private static AESCipherSecurity instance = new AESCipherSecurity();

    public static AESCipherSecurity getInstance() {
        return instance;
    }

    public AESCipherSecurity() {
        this.updateKeyMap();
    }

    @Override
    public String encrypt(String PlainData) {
        CipherInfo cipherInfo = this.getCipherInfo();
        byte[] bytes = this.encryptToByte(PlainData, cipherInfo);
        if (bytes != null) {
            int version = this.getVersion();
            StringBuilder sb = new StringBuilder();
            sb.append(Base64.encodeBase64String((byte[])bytes));
            sb.append('|');
            sb.append(version);
            return sb.toString();
        }
        return "";
    }

    public String encrypt(byte[] PlainData) {
        CipherInfo cipherInfo = this.getCipherInfo();
        byte[] bytes = this.encryptToByte(PlainData, cipherInfo);
        if (bytes != null) {
            int version = this.getVersion();
            StringBuilder sb = new StringBuilder();
            sb.append(Base64.encodeBase64String((byte[])bytes));
            sb.append('|');
            sb.append(version);
            return sb.toString();
        }
        return "";
    }

    public byte[] encryptToByte(byte[] PlainData) {
        CipherInfo cipherInfo = this.getCipherInfo();
        return this.encryptToByte(PlainData, cipherInfo);
    }

    public byte[] encryptToByte(String content, CipherInfo cipherInfo) {
        return this.encryptToByte(content.getBytes(), cipherInfo);
    }

    public byte[] encryptToByte(byte[] content, CipherInfo cipherInfo) {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, cipherInfo.getSecretKey());
            byte[] iv = cipher.getIV();
            assert (iv.length == 12);
            byte[] encryptData = cipher.doFinal(content);
            assert (encryptData.length == content.length + 16);
            byte[] message = new byte[12 + content.length + 16];
            System.arraycopy(iv, 0, message, 0, 12);
            System.arraycopy(encryptData, 0, message, 12, encryptData.length);
            return message;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.monitorError("ebg APICipherSecurity encryptToByte error: " + e.toString(), e);
            return content;
        }
    }

    @Override
    public String decrypt(String cipherData) {
        CipherInfo cipherInfo = this.getCipherInfo(cipherData);
        String data = cipherInfo.getCipherData();
        int version = cipherInfo.getCipherVersion();
        return this.decrypt(data, this.getCipherInfo(version));
    }

    public byte[] decryptToBytes(byte[] cipherData, int version) {
        CipherInfo cipherInfo = this.getCipherInfo(version);
        return this.decryptToByte(cipherData, cipherInfo);
    }

    @Override
    public String decrypt(String cipherData, int version) {
        CipherInfo cipherInfo = this.getCipherInfo(version);
        return this.decrypt(cipherData, cipherInfo);
    }

    private String decrypt(String base64Content, CipherInfo cipherInfo) {
        byte[] bytes = this.decryptBase64ToByte(base64Content, cipherInfo);
        if (bytes != null) {
            return StringUtils.byteToString(bytes);
        }
        return "";
    }

    private byte[] decryptBase64ToByte(String base64Content, CipherInfo cipherInfo) {
        byte[] content = Base64.decodeBase64((String)base64Content);
        return this.decryptToByte(content, cipherInfo);
    }

    public byte[] decryptToByte(byte[] content, CipherInfo cipherInfo) {
        if (content.length < 28) {
            throw new IllegalArgumentException();
        }
        GCMParameterSpec params = new GCMParameterSpec(128, content, 0, 12);
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)cipherInfo.getSecretKey(), params);
            byte[] decryptData = cipher.doFinal(content, 12, content.length - 12);
            return decryptData;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.monitorError("ebg APICipherSecurity decryptToByte error: " + e.toString(), e);
            return content;
        }
    }

    @SdkDeprecated
    public CipherInfo getCipherInfo(String cipherData) {
        CipherInfo cInfo = new CipherInfo();
        int version = 1;
        String[] data = cipherData.split("\\|");
        if (data.length == 2) {
            version = Integer.parseInt(data[1]);
        }
        cInfo.setCipherData(data[0]);
        cInfo.setCipherVersion(version);
        return cInfo;
    }
}

