/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.service.acnt;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.service.bank.BankLoginService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.model.currency.BankCurrencyKey;
import kd.ebg.egf.common.model.currency.IsoCurrency;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.currency.BankCurrencyRepository;
import kd.ebg.egf.common.repository.currency.IsoCurrencyRepository;
import kd.sdk.annotation.SdkDeprecated;

public class BankAcntService {
    static final String ENTITY_KEY_OBJECT_PROPERTIES = "aqap_object_properties";
    private static BankAcntService instance = new BankAcntService();
    public static final List<String> EB_CURRENCIES = Lists.newArrayList((Object[])new String[]{"CNY", "USD", "HKD", "JPY", "EUR", "GBP", "CHF", "MOP", "TWD", "CAD", "AUD", "KRW", "NZD", "SGD"});
    private BankAcntRepository bankAcntRepository = BankAcntRepository.getInstance();

    public List<String> getEbCurrencies() {
        IsoCurrencyRepository isoCurrencyRepository = IsoCurrencyRepository.getInstance();
        List<IsoCurrency> isoCurrencies = isoCurrencyRepository.findAll();
        if (isoCurrencies != null && isoCurrencies.size() > 0) {
            ArrayList<String> result = new ArrayList<String>(1);
            for (IsoCurrency currency : isoCurrencies) {
                result.add(currency.getIsoCode().toUpperCase(Locale.ENGLISH));
            }
            return result;
        }
        return EB_CURRENCIES;
    }

    public List<BankAcnt> getNotDeleteAcntByBankLoginIDAndCustomID(String bankLoginID, String customID) {
        return this.bankAcntRepository.findListByCustomIDAndBankLoginIDAndEnable(customID, bankLoginID, "1");
    }

    public boolean currencySupported(String isoCurrency, String bankLoginId, String customerNo) {
        BankLogin login = BankLoginService.getInstance().getByCustomIdAndLoginId(customerNo, bankLoginId);
        return this.currencySupportedByBankVersionID(isoCurrency, login.getBankVersionId(), customerNo);
    }

    public boolean currencySupportedByBankVersionID(String isoCurrency, String bankVersionId, String customerNo) {
        BankCurrencyRepository bankCurrencyRepository = BankCurrencyRepository.getInstance();
        BankCurrencyKey key = new BankCurrencyKey();
        key.setBankVersionId(bankVersionId);
        key.setCustomID("admin");
        key.setIsoCode(isoCurrency);
        if (!bankCurrencyRepository.existsById(key)) {
            key.setCustomID(customerNo);
            return bankCurrencyRepository.existsById(key);
        }
        return true;
    }

    public static BankAcntService getInstance() {
        return instance;
    }

    @SdkDeprecated
    public BankAcnt selectByCustomIDAndAccNo(String accNo, String customID) {
        return this.bankAcntRepository.findByAccNoAndCustomID(accNo, customID);
    }

    public BankAcnt selectEnableByCustomIDAndAccNo(String accNo, String customID) {
        return this.bankAcntRepository.findEnableByAccNo(accNo);
    }

    public List<BankAcnt> selectByBankVersionAndBankLogin(String bankVersionId, String bankLoginId) {
        List<BankAcnt> allBankAcnts = this.selectAll();
        return allBankAcnts.stream().filter(item -> Objects.equals(item.getBankVersionId(), bankVersionId) && Objects.equals(item.getBankLoginId(), bankLoginId)).collect(Collectors.toList());
    }

    public List<BankAcnt> selectByCustomIdAndBankVersion(String customId, String bankVersionId) {
        List<BankAcnt> allBankAcnts = this.selectAll();
        return allBankAcnts.stream().filter(item -> Objects.equals(item.getBankVersionId(), bankVersionId) && Objects.equals(item.getCustomID(), customId)).collect(Collectors.toList());
    }

    public int selectReceiptAcntCountByCustomIdAndBankVersion(String customId, String bankVersionId) {
        return this.bankAcntRepository.countByCustomIDAndBankVersionIdAndHasReceipt(customId, bankVersionId, true);
    }

    public List<BankAcnt> findByCustomIDAndBankVersionIdAndBankLoginIdAndHasReceipt(String customId, String bankVersionId, String bankLoginId, boolean hasReceipt) {
        return this.bankAcntRepository.findByCustomIDAndBankVersionIdAndBankLoginIdAndHasReceipt(customId, bankVersionId, bankLoginId, hasReceipt);
    }

    public List<BankAcnt> findByBankVersionIdAndBankLoginIdAndHasReceipt(String bankVersionId, String bankLoginId, boolean hasReceipt) {
        return this.bankAcntRepository.findByBankVersionIdAndBankLoginIdAndHasReceipt(bankVersionId, bankLoginId, hasReceipt);
    }

    public BankAcnt selectByAccNo(String accNo) {
        String customId = EBContext.getContext().getCustomID();
        BankAcnt bankAcnt = this.bankAcntRepository.findByAccNoAndCustomID(accNo, customId);
        return bankAcnt;
    }

    public List<BankAcnt> selectAll() {
        String customId = EBContext.getContext().getCustomID();
        return this.bankAcntRepository.findByCustomID(customId);
    }

    public static boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return !BankAcntService.isEmpty(coll);
    }

    public void deleteByAccNo(String accNo) {
        QFilter filter = QFilter.of((String)"number=?", (Object[])new Object[]{accNo});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"aqap_bank_acnt", (String)"enable", (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            dynamicObject.set("enable", (Object)0);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    private void checkNull(String tip, DynamicObject obj, String info) {
        if (obj == null) {
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"%1$s,[%2$s]\u4e0d\u5b58\u5728", (String)"BankAcntService_0", (String)"ebg-egf-common", (Object[])new Object[0]), tip, info));
        }
    }

    private String dealAcntCity(String city) {
        int index = city.indexOf(ResManager.loadKDString((String)"\u5e02", (String)"BankAcntService_1", (String)"ebg-egf-common", (Object[])new Object[0]));
        if (index > 0) {
            return city.substring(0, index);
        }
        return city;
    }

    private List<DynamicObject> getDynamicObjList(Map<String, Object> params, String accNo) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            DynamicObject dynamicObject = this.getObjectEntity(entry.getKey(), entry.getValue(), accNo);
            if (dynamicObject == null) continue;
            dynamicObjectList.add(dynamicObject);
        }
        return dynamicObjectList;
    }

    private DynamicObject getObjectEntity(String key, Object value, String accNo) {
        QFilter filter = QFilter.of((String)"attr_key=? and object_id=? and object_name=?", (Object[])new Object[]{key, accNo, "BANK_BUSINESS"});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY_KEY_OBJECT_PROPERTIES, (String)"attr_value", (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            dynamicObject.set("attr_value", value);
        }
        return dynamicObject;
    }

    public DynamicObject[] getAccnoProperty(String accNo) {
        QFilter filter = QFilter.of((String)"object_id=? and object_name=?", (Object[])new Object[]{accNo, "BANK_BUSINESS"});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_KEY_OBJECT_PROPERTIES, (String)"attr_key,attr_value", (QFilter[])filter.toArray());
        return dynamicObjects;
    }

    public List<BankAcnt> selectReconciliationByCustomIdAndBankVersion(String customId, String bankVersionId) {
        List<BankAcnt> allBankAcnts = this.bankAcntRepository.findByCustomIDAndBankVersionIdAndHasReconciliation(customId, bankVersionId, true);
        return allBankAcnts;
    }

    public List<BankAcnt> findByBankVersionIdAndBankLoginIdAndHasReconciliation(String bankVersionId, String bankLoginId, boolean hasReconciliation) {
        return this.bankAcntRepository.findByBankVersionIdAndBankLoginIdAndHasReconciliation(bankVersionId, bankLoginId, hasReconciliation);
    }
}

