/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.service.properties;

import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.model.properties.ObjectProperties;
import kd.ebg.egf.common.model.properties.ObjectPropertiesKey;
import kd.ebg.egf.common.repository.properties.ObjectPropertiesRepository;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectPropertyService {
    private static final String SEPARATOR = "[;\n]";
    private static Logger logger = LoggerFactory.getLogger(ObjectPropertyService.class);
    private static ObjectPropertyService instance = new ObjectPropertyService();
    private ObjectPropertiesRepository objectPropertiesRepository = ObjectPropertiesRepository.getInstance();

    public static ObjectPropertyService getInstance() {
        return instance;
    }

    public String getPropertyValue(ObjectPropertiesKey key) {
        Preconditions.checkNotNull((Object)key, (Object)ResManager.loadKDString((String)"\u5f85\u67e5\u8be2\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ObjectPropertyService_0", (String)"ebg-egf-common", (Object[])new Object[0]));
        ObjectProperties objectProperties = this.objectPropertiesRepository.findById(key);
        return Optional.ofNullable(objectProperties).map(ObjectProperties::getAttrValue).orElse(null);
    }

    public List<String> getPropertyValues(ObjectPropertiesKey key) {
        ArrayList<String> attrValueList = new ArrayList<String>(16);
        Preconditions.checkNotNull((Object)key, (Object)ResManager.loadKDString((String)"\u5f85\u67e5\u8be2\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ObjectPropertyService_0", (String)"ebg-egf-common", (Object[])new Object[0]));
        ObjectProperties objectProperties = this.objectPropertiesRepository.findById(key);
        if (objectProperties != null && objectProperties.getAttrValue() != null) {
            String[] attrValues;
            for (String item : attrValues = objectProperties.getAttrValue().split(SEPARATOR)) {
                if (!StringUtils.isNotEmpty(item)) continue;
                attrValueList.add(item);
            }
        }
        return attrValueList;
    }

    public void setPropertyValue(ObjectPropertiesKey key, String value, String desc) {
        Preconditions.checkNotNull((Object)key, (Object)ResManager.loadKDString((String)"\u5f85\u63d2\u5165\u8bb0\u5f55\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ObjectPropertyService_1", (String)"ebg-egf-common", (Object[])new Object[0]));
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank(value), (Object)ResManager.loadKDString((String)"\u5f85\u63d2\u5165value \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ObjectPropertyService_2", (String)"ebg-egf-common", (Object[])new Object[0]));
        ObjectProperties objectProperties = new ObjectProperties();
        objectProperties.setKey(key);
        objectProperties.setAttrDesc(desc);
        objectProperties.setAttrValue(value);
        objectProperties.setCreateTime(LocalDateTime.now());
        objectProperties.setUpdateTime(LocalDateTime.now());
        this.objectPropertiesRepository.save(objectProperties);
    }

    public void setPropertyValues(ObjectPropertiesKey key, List<String> values, String desc) {
        Preconditions.checkNotNull((Object)key, (Object)ResManager.loadKDString((String)"\u5f85\u63d2\u5165\u8bb0\u5f55\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ObjectPropertyService_1", (String)"ebg-egf-common", (Object[])new Object[0]));
        Preconditions.checkNotNull(values, (Object)ResManager.loadKDString((String)"\u5f85\u63d2\u5165\u7684value \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ObjectPropertyService_3", (String)"ebg-egf-common", (Object[])new Object[0]));
        Preconditions.checkArgument((!values.isEmpty() ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u5f85\u63d2\u5165\u7684value List \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ObjectPropertyService_4", (String)"ebg-egf-common", (Object[])new Object[0]));
        String value = values.stream().filter(StrUtil::isNotBlank).collect(Collectors.joining(SEPARATOR));
        this.setPropertyValue(key, value, desc);
    }

    public void delete(ObjectPropertiesKey key) {
        Preconditions.checkNotNull((Object)key, (Object)ResManager.loadKDString((String)"\u5f85\u5220\u9664\u8bb0\u5f55\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ObjectPropertyService_5", (String)"ebg-egf-common", (Object[])new Object[0]));
    }

    public void update(ObjectPropertiesKey key, String value, String desc) {
        Preconditions.checkNotNull((Object)key, (Object)ResManager.loadKDString((String)"\u5f85\u66f4\u65b0\u8bb0\u5f55\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ObjectPropertyService_6", (String)"ebg-egf-common", (Object[])new Object[0]));
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank(value), (Object)ResManager.loadKDString((String)"\u66f4\u65b0\u7684 value \u4e0d\u80fd\u4e3a\u7a7a", (String)"ObjectPropertyService_7", (String)"ebg-egf-common", (Object[])new Object[0]));
        ObjectProperties objectProperties = this.objectPropertiesRepository.findById(key);
        if (Objects.nonNull(objectProperties)) {
            objectProperties.setAttrValue(value);
            objectProperties.setAttrDesc(desc);
            objectProperties.setUpdateTime(LocalDateTime.now());
            this.objectPropertiesRepository.save(objectProperties);
        } else {
            logger.info("\u8981\u66f4\u65b0\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728 key:{}", (Object)key);
        }
    }

    public void update(ObjectPropertiesKey key, List<String> values, String desc) {
        Preconditions.checkNotNull((Object)key, (Object)ResManager.loadKDString((String)"\u5f85\u66f4\u65b0\u8bb0\u5f55\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ObjectPropertyService_6", (String)"ebg-egf-common", (Object[])new Object[0]));
        Preconditions.checkNotNull(values, (Object)ResManager.loadKDString((String)"\u5f85\u66f4\u65b0\u7684values\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ObjectPropertyService_8", (String)"ebg-egf-common", (Object[])new Object[0]));
        String value = values.stream().filter(StrUtil::isNotBlank).collect(Collectors.joining(SEPARATOR));
        this.update(key, value, desc);
    }

    public List<ObjectProperties> selectByCustomID(String customID) {
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank(customID), (Object)ResManager.loadKDString((String)"\u5f85\u67e5\u8be2\u7684\u5ba2\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ObjectPropertyService_9", (String)"ebg-egf-common", (Object[])new Object[0]));
        return this.objectPropertiesRepository.findByCustomID(customID);
    }

    public void saveAcntProperties(String key, String value, String accno) {
        String objectName = "BANK_BUSINESS";
        DynamicObject dynamicObject = this.objectPropertiesRepository.loadDynamicObject(key, accno, objectName);
        if (dynamicObject != null) {
            dynamicObject.set("attr_value", (Object)value);
            SaveServiceHelper.save((IDataEntityType)dynamicObject.getDataEntityType(), (Object[])new DynamicObject[]{dynamicObject});
            return;
        }
        this.objectPropertiesRepository.save(key, value, accno, objectName);
    }

    public String getBankSearchDetailDate(String bankVersionID) {
        ObjectProperties objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("detail_search_date", "BANK_BUSINESS", bankVersionID);
        if (objectProperties != null) {
            return objectProperties.getAttrValue();
        }
        return "";
    }

    public String getAccnoSearchLimit(String accNo) {
        ObjectProperties objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("accno_search_limit", "BANK_BUSINESS", accNo);
        if (objectProperties != null) {
            return objectProperties.getAttrValue();
        }
        return "";
    }
}

