/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.task;

import java.util.concurrent.Callable;
import java.util.concurrent.locks.LockSupport;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.task.BizTaskTool;
import kd.ebg.egf.common.framework.task.ThreadConcurrencySupport;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;

public abstract class AbstractTask
implements Callable {
    EBGLogger logger = EBGLogger.getInstance().getLogger(AbstractTask.class);
    private boolean isParkError = false;
    private int maxThreadNum;
    private String taskId;
    private EBContext context;
    private boolean skip = false;
    private String bizQueryParam;
    public static final int MAX = 99999;
    public static final int DEFAULT = 120;
    private ThreadConcurrencySupport threadConcurrencySupport = ThreadConcurrencySupport.getInstance();

    public Object call() {
        try {
            this.setTaskProcessing();
            this.countIncAndPark();
            if (this.isSkip()) {
                this.logger.warn("Current task is skipped by BizTask");
                Object var1_1 = null;
                return var1_1;
            }
            Object object = this.doBiz();
            return object;
        }
        catch (Throwable t) {
            this.logger.error("Async Task Error", t);
            Object var2_4 = null;
            return var2_4;
        }
        finally {
            this.countDecAndUnPark();
            this.setTaskFinish();
        }
    }

    public abstract Object doBiz();

    private void countIncAndPark() {
        this.refreshMaxThreadNum();
        if (this.threadConcurrencySupport.incrementAndGet() > this.maxThreadNum) {
            if (!this.threadConcurrencySupport.offer()) {
                this.isParkError = true;
                throw new IllegalStateException("currentThread add to threadQueue fail");
            }
            LockSupport.park();
            this.logger.info(Thread.currentThread().getName() + " has been waked up");
        }
    }

    private void countDecAndUnPark() {
        Thread t;
        if (!this.isParkError && (t = this.threadConcurrencySupport.poll()) != null) {
            LockSupport.unpark(t);
            this.logger.info(Thread.currentThread().getName() + " is going to wake up");
        }
        this.threadConcurrencySupport.decrementAndGet();
    }

    private int getMaxThreadNum() {
        return this.maxThreadNum;
    }

    private void refreshMaxThreadNum() {
        this.maxThreadNum = this.getThreadMaxNum();
    }

    private int getThreadMaxNum() {
        Long maxThreadNum = Long.getLong("ebg_maxThreadNum");
        if (maxThreadNum == null) {
            return 99999;
        }
        try {
            int realNum = Math.toIntExact(maxThreadNum);
            if (realNum < 0) {
                realNum = 120;
            } else if (realNum == 0) {
                realNum = 99999;
            }
            return realNum;
        }
        catch (Throwable e) {
            return 99999;
        }
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public EBContext getContext() {
        return this.context;
    }

    private void setTaskProcessing() {
        DynamicObject dynamicObject = BizTaskTool.getInstance().setTaskProcessing(this.taskId);
        if (dynamicObject != null) {
            this.setSkip("1".equalsIgnoreCase(dynamicObject.getString("is_skip")));
            this.createEBContext(dynamicObject);
        }
    }

    private void setTaskFinish() {
        BizTaskTool.getInstance().setTaskFinish(this.taskId);
    }

    private void createEBContext(DynamicObject dynamicObject) {
        String bizType = dynamicObject.getString("biz_type");
        String subBizType = dynamicObject.getString("sub_biz_type");
        String accNo = dynamicObject.getString("acc_no");
        String requestSeqId = dynamicObject.getString("request_seq");
        String bankVersion = dynamicObject.getString("bank_version");
        String bankLogin = dynamicObject.getString("bank_login");
        String bankBatchSeqID = dynamicObject.getString("bank_batch_no");
        String batchSeqID = dynamicObject.getString("biz_no");
        String loggerBatchNo = dynamicObject.getString("logger_no");
        String loggerBankNo = dynamicObject.getString("logger_bank_no");
        this.setBizQueryParam(bankBatchSeqID);
        this.context = EBContext.builder().createTime(System.currentTimeMillis()).customID(RequestContext.get().getTenantId()).requestSeqID(requestSeqId).bizName(bizType).subBizName(subBizType).bankVersionID(bankVersion).bizSeqID(batchSeqID).bankLoginID(bankLogin).logRequestSeqID(loggerBatchNo).logBizSeqID(loggerBatchNo).loggerBatchNo(loggerBatchNo).loggerDetailNo(bankBatchSeqID).loggerBankNo(loggerBankNo).build();
        BankAcnt bankAcnt = BankAcntRepository.getInstance().findByAccNoAndCustomID(accNo, RequestContext.get().getTenantId());
        this.context.setBankAcnt(bankAcnt);
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public String getBizQueryParam() {
        return this.bizQueryParam;
    }

    public void setBizQueryParam(String bizQueryParam) {
        this.bizQueryParam = bizQueryParam;
    }
}

