/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.license;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.license.api.ILicenseService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.ebg.egf.common.log.EBGLogger;

public class LicenseTask {
    private String id = UUID.randomUUID().toString();
    private String tenantId;
    private String version = "1.0";
    private String expiredDate = "1999-12-31 23:59:59";
    private int licenseCount = 0;
    private String fileType = ResManager.loadKDString((String)"\u672a\u77e5", (String)"LicenseTask_0", (String)"ebg-egf-common", (Object[])new Object[0]);
    private static final Map<String, LicenseTask> tasks = new ConcurrentHashMap<String, LicenseTask>();
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(LicenseTask.class);

    private LicenseTask(String tenantId) {
        this.tenantId = tenantId;
    }

    public static LicenseTask getTask() {
        RequestContext ctx = RequestContext.get();
        String tenantId = ctx.getTenantId();
        LicenseTask task = new LicenseTask(tenantId);
        task.refreshLicense();
        return task;
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getExpiredDate() {
        return this.expiredDate;
    }

    public int getLicenseCount() {
        return this.licenseCount;
    }

    public String getFileType() {
        return this.fileType;
    }

    public static Map<String, LicenseTask> getTasks() {
        return tasks;
    }

    private void refreshLicense() {
        this.refreshVersion();
        this.refreshLicenseCount();
        this.refreshProductInfo();
    }

    private void refreshProductInfo() {
        Date expireDate;
        Map groupTimeRange;
        String type;
        String licenseEbgGroupId = "523";
        Map productInfo = LicenseServiceHelper.getProductInfo();
        if (productInfo != null && (type = (String)productInfo.get("type")) != null) {
            this.fileType = type;
        }
        if (this.isXkKitModel()) {
            licenseEbgGroupId = "2050115096541137920";
        }
        if ((groupTimeRange = LicenseServiceHelper.getGroupTimeRange((Long)Long.parseLong(licenseEbgGroupId))) != null && (expireDate = (Date)groupTimeRange.get("expireDate")) != null) {
            this.expiredDate = expireDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
    }

    private void refreshLicenseCount() {
        int i;
        String groupId = "523";
        if (this.isXkKitModel()) {
            groupId = "2050115096541137920";
        }
        if ((i = LicenseServiceHelper.getTotalNumber((Object)groupId)) > 0) {
            this.licenseCount = i;
        }
    }

    private void refreshVersion() {
        try {
            String s = LicenseServiceHelper.getProductVersion();
            if (s != null) {
                this.version = s;
            }
        }
        catch (Exception e) {
            logger.error("\u4ece\u5e73\u53f0\u83b7\u53d6\u8bb8\u53ef\u7248\u672c\u5f02\u5e38", e);
        }
    }

    private boolean isXkKitModel() {
        boolean flag = false;
        ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modeType = service.getModeType();
        if (modeType == 4) {
            try {
                String licenseControlModel = (String)DispatchServiceHelper.invokeBizService((String)"sys", (String)"xkbase", (String)"ILicenseService", (String)"getLicenseControlModel", (Object[])new Object[0]);
                if ("kit".equalsIgnoreCase(licenseControlModel)) {
                    flag = true;
                }
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u661f\u7a7a\u5fae\u670d\u52a1\u83b7\u53d6\u8bb8\u53ef\u63a7\u5236\u6a21\u5f0f\u5f02\u5e38", e);
            }
        }
        return flag;
    }
}

