/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.model.data;

import java.util.List;
import kd.ebg.egf.common.model.data.Page;
import kd.ebg.egf.common.model.data.Pageable;

public class PageImpl<T>
implements Page<T> {
    private int number;
    private int size;
    private long totalElements;
    private List<T> content;

    public PageImpl(List<T> content, Pageable pageable, long total) {
        this.content = content;
        this.totalElements = total;
        this.number = pageable.getPageNumber();
        this.size = pageable.getPageSize();
    }

    public PageImpl() {
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getTotalPages() {
        return this.getSize() == 0 ? 1 : (int)Math.ceil((double)this.totalElements / (double)this.getSize());
    }

    @Override
    public long getTotalElements() {
        return this.totalElements;
    }

    @Override
    public List getContent() {
        return this.content;
    }

    @Override
    public boolean isLast() {
        return !this.hastNext();
    }

    public boolean hastNext() {
        return this.getNumber() + 1 < this.getTotalPages();
    }
}

